/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.operation.buffer.SubgraphDepthLocater;

public class DepthSegmentTest
extends TestCase {
    public DepthSegmentTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(DepthSegmentTest.class);
    }

    public void testContractTipToTail() throws Exception {
        SubgraphDepthLocater.DepthSegment ds0 = this.depthSeg(0.7, 0.2, 1.4, 0.9);
        SubgraphDepthLocater.DepthSegment ds1 = this.depthSeg(0.3, 1.1, 0.7, 0.2);
        this.checkContract(ds0, ds1);
    }

    public void testContract2() throws Exception {
        SubgraphDepthLocater.DepthSegment ds0 = this.depthSeg(0.1, 1.9, 0.5, 1.0);
        SubgraphDepthLocater.DepthSegment ds1 = this.depthSeg(1.0, 0.9, 1.9, 1.4);
        this.checkContract(ds0, ds1);
    }

    private void checkContract(SubgraphDepthLocater.DepthSegment ds0, SubgraphDepthLocater.DepthSegment ds1) {
        int cmp0 = ds0.compareTo(ds1);
        int cmp1 = ds1.compareTo(ds0);
        boolean isFail = cmp0 != 0 && cmp0 == cmp1;
        DepthSegmentTest.assertTrue((!isFail ? 1 : 0) != 0);
    }

    private SubgraphDepthLocater.DepthSegment depthSeg(double x0, double y0, double x1, double y1) {
        return new SubgraphDepthLocater.DepthSegment(new LineSegment(x0, y0, x1, y1), 0);
    }
}

