/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;

public class Vector3DTest
extends TestCase {
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(Vector3DTest.class);
    }

    public Vector3DTest(String name) {
        super(name);
    }

    public void testLength() {
        Vector3DTest.assertEquals((double)1.0, (double)Vector3DTest.create(0.0, 1.0, 0.0).length(), (double)1.0E-5);
        Vector3DTest.assertEquals((double)1.0, (double)Vector3DTest.create(0.0, -1.0, 0.0).length(), (double)1.0E-5);
        Vector3DTest.assertEquals((double)Math.sqrt(2.0), (double)Vector3DTest.create(1.0, 1.0, 0.0).length(), (double)1.0E-5);
        Vector3DTest.assertEquals((double)5.0, (double)Vector3DTest.create(3.0, 4.0, 0.0).length(), (double)1.0E-5);
        Vector3DTest.assertEquals((double)Math.sqrt(3.0), (double)Vector3DTest.create(1.0, 1.0, 1.0).length(), (double)1.0E-5);
        Vector3DTest.assertEquals((double)Math.sqrt(14.0), (double)Vector3DTest.create(1.0, 2.0, 3.0).length(), (double)1.0E-5);
    }

    public void testAdd() {
        this.assertEquals(Vector3DTest.create(5.0, 7.0, 9.0), Vector3DTest.create(1.0, 2.0, 3.0).add(Vector3DTest.create(4.0, 5.0, 6.0)));
    }

    public void testSubtract() {
        this.assertEquals(Vector3DTest.create(-3.0, 0.0, 3.0), Vector3DTest.create(1.0, 5.0, 9.0).subtract(Vector3DTest.create(4.0, 5.0, 6.0)));
    }

    public void testDivide() {
        this.assertEquals(Vector3DTest.create(1.0, 2.0, 3.0), Vector3DTest.create(2.0, 4.0, 6.0).divide(2.0));
    }

    public void testDot() {
        Vector3DTest.assertEquals((Object)20.0, (Object)Vector3DTest.create(2.0, 3.0, 4.0).dot(Vector3DTest.create(1.0, 2.0, 3.0)));
    }

    public void testDotABCD() {
        double dot = Vector3D.dot(Vector3DTest.coord(2.0, 3.0, 4.0), Vector3DTest.coord(3.0, 4.0, 5.0), Vector3DTest.coord(0.0, 1.0, -1.0), Vector3DTest.coord(1.0, 5.0, 2.0));
        Vector3DTest.assertEquals((Object)8.0, (Object)dot);
        Vector3DTest.assertEquals((Object)dot, (Object)Vector3DTest.create(1.0, 1.0, 1.0).dot(Vector3DTest.create(1.0, 4.0, 3.0)));
    }

    public void testNormlize() {
        this.assertEquals(Vector3DTest.create(-0.5773502691896258, 0.5773502691896258, 0.5773502691896258), Vector3DTest.create(-1.0, 1.0, 1.0).normalize());
        this.assertEquals(Vector3DTest.create(0.5773502691896258, 0.5773502691896258, 0.5773502691896258), Vector3DTest.create(2.0, 2.0, 2.0).normalize());
        this.assertEquals(Vector3DTest.create(0.2672612419124244, 0.5345224838248488, 0.8017837257372732), Vector3DTest.create(1.0, 2.0, 3.0).normalize());
    }

    static Coordinate coord(double x, double y, double z) {
        return new Coordinate(x, y, z);
    }

    static Vector3D create(double x, double y, double z) {
        return Vector3D.create(x, y, z);
    }

    void assertEquals(Vector3D expected, Vector3D actual) {
        boolean isEqual = expected.equals(actual);
        if (!isEqual) {
            System.out.println("Expected " + expected + " but actual is " + actual);
        }
        Vector3DTest.assertTrue((boolean)isEqual);
    }

    void assertEquals(Vector3D expected, Vector3D actual, double tolerance) {
        Vector3DTest.assertEquals((double)expected.getX(), (double)actual.getX(), (double)tolerance);
        Vector3DTest.assertEquals((double)expected.getY(), (double)actual.getY(), (double)tolerance);
        Vector3DTest.assertEquals((double)expected.getZ(), (double)actual.getZ(), (double)tolerance);
    }
}

