/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.math.Vector2D;

public class Vector2DTest
extends TestCase {
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(Vector2DTest.class);
    }

    public Vector2DTest(String name) {
        super(name);
    }

    public void testLength() {
        Vector2DTest.assertEquals((double)Vector2D.create(0.0, 1.0).length(), (double)1.0, (double)1.0E-5);
        Vector2DTest.assertEquals((double)Vector2D.create(0.0, -1.0).length(), (double)1.0, (double)1.0E-5);
        Vector2DTest.assertEquals((double)Vector2D.create(1.0, 1.0).length(), (double)Math.sqrt(2.0), (double)1.0E-5);
        Vector2DTest.assertEquals((double)Vector2D.create(3.0, 4.0).length(), (double)5.0, (double)1.0E-5);
    }

    public void testIsParallel() throws Exception {
        Vector2DTest.assertTrue((boolean)Vector2D.create(0.0, 1.0).isParallel(Vector2D.create(0.0, 2.0)));
        Vector2DTest.assertTrue((boolean)Vector2D.create(1.0, 1.0).isParallel(Vector2D.create(2.0, 2.0)));
        Vector2DTest.assertTrue((boolean)Vector2D.create(-1.0, -1.0).isParallel(Vector2D.create(2.0, 2.0)));
        Vector2DTest.assertTrue((!Vector2D.create(1.0, -1.0).isParallel(Vector2D.create(2.0, 2.0)) ? 1 : 0) != 0);
    }

    public void testToCoordinate() {
        this.assertEquals(Vector2D.create(Vector2D.create(1.0, 2.0).toCoordinate()), Vector2D.create(1.0, 2.0), 1.0E-5);
    }

    void assertEquals(Vector2D v1, Vector2D v2) {
        Vector2DTest.assertTrue((boolean)v1.equals(v2));
    }

    void assertEquals(Vector2D v1, Vector2D v2, double tolerance) {
        Vector2DTest.assertEquals((double)v1.getX(), (double)v2.getX(), (double)tolerance);
        Vector2DTest.assertEquals((double)v1.getY(), (double)v2.getY(), (double)tolerance);
    }
}

