/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.gml2;

import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.gml2.GMLReader;
import org.xml.sax.SAXException;

public class GMLReaderTestCase
extends TestCase {
    private static final String TEST_DIR = "bin/data/";
    protected static PrecisionModel precisionModel = new PrecisionModel(1000.0);
    protected static GeometryFactory geometryFactory = new GeometryFactory(precisionModel);

    public GMLReaderTestCase(String arg0) {
        super(arg0);
    }

    public void testPointRead() throws SAXException, IOException, ParserConfigurationException {
        GMLReader gr = new GMLReader();
        FileReader fr = new FileReader("bin/data/points.xml");
        Geometry g = gr.read(fr, geometryFactory);
        GeometryCollection gc = (GeometryCollection)g;
        GMLReaderTestCase.assertTrue((gc.getNumGeometries() == 25 ? 1 : 0) != 0);
        for (int i = 0; i < 25; ++i) {
            Point p = (Point)gc.getGeometryN(i);
            GMLReaderTestCase.assertNotNull((Object)p);
        }
    }

    public void testLineStringRead() throws SAXException, IOException, ParserConfigurationException {
        GMLReader gr = new GMLReader();
        FileReader fr = new FileReader("bin/data/linestrings.xml");
        Geometry g = gr.read(fr, geometryFactory);
        GeometryCollection gc = (GeometryCollection)g;
        GMLReaderTestCase.assertTrue((gc.getNumGeometries() == 25 ? 1 : 0) != 0);
        for (int i = 0; i < 25; ++i) {
            LineString ls = (LineString)gc.getGeometryN(i);
            GMLReaderTestCase.assertNotNull((Object)ls);
        }
    }

    public void testPolygonRead() throws SAXException, IOException, ParserConfigurationException {
        GMLReader gr = new GMLReader();
        FileReader fr = new FileReader("bin/data/polygons.xml");
        Geometry g = gr.read(fr, geometryFactory);
        GeometryCollection gc = (GeometryCollection)g;
        GMLReaderTestCase.assertTrue((gc.getNumGeometries() == 25 ? 1 : 0) != 0);
        for (int i = 0; i < 25; ++i) {
            Polygon p = (Polygon)gc.getGeometryN(i);
            GMLReaderTestCase.assertNotNull((Object)p);
        }
    }

    public void testMultiPointRead() throws SAXException, IOException, ParserConfigurationException {
        GMLReader gr = new GMLReader();
        FileReader fr = new FileReader("bin/data/multipoints.xml");
        Geometry g = gr.read(fr, geometryFactory);
        GeometryCollection gc = (GeometryCollection)g;
        GMLReaderTestCase.assertTrue((gc.getNumGeometries() == 25 ? 1 : 0) != 0);
        for (int i = 0; i < 25; ++i) {
            MultiPoint p = (MultiPoint)gc.getGeometryN(i);
            GMLReaderTestCase.assertNotNull((Object)p);
        }
    }

    public void testMultiLineStringRead() throws SAXException, IOException, ParserConfigurationException {
        GMLReader gr = new GMLReader();
        FileReader fr = new FileReader("bin/data/multilinestrings.xml");
        Geometry g = gr.read(fr, geometryFactory);
        GeometryCollection gc = (GeometryCollection)g;
        GMLReaderTestCase.assertTrue((gc.getNumGeometries() == 25 ? 1 : 0) != 0);
        for (int i = 0; i < 25; ++i) {
            MultiLineString ls = (MultiLineString)gc.getGeometryN(i);
            GMLReaderTestCase.assertNotNull((Object)ls);
        }
    }

    public void testMultiPolygonRead() throws SAXException, IOException, ParserConfigurationException {
        GMLReader gr = new GMLReader();
        FileReader fr = new FileReader("bin/data/multipolygons.xml");
        Geometry g = gr.read(fr, geometryFactory);
        GeometryCollection gc = (GeometryCollection)g;
        GMLReaderTestCase.assertTrue((gc.getNumGeometries() == 25 ? 1 : 0) != 0);
        for (int i = 0; i < 25; ++i) {
            MultiPolygon p = (MultiPolygon)gc.getGeometryN(i);
            GMLReaderTestCase.assertNotNull((Object)p);
        }
    }
}

