/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class WKTReadWriteTest
extends TestCase {
    private final CoordinateSequenceFactory csFactory = PackedCoordinateSequenceFactory.DOUBLE_FACTORY;
    private final GeometryFactory geometryFactory = new GeometryFactory(this.csFactory);
    private final WKTReader reader = new WKTReader(this.geometryFactory);
    private final WKTWriter writer = new WKTWriter(4);

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(WKTReadWriteTest.class));
    }

    public WKTReadWriteTest(String name) {
        super(name);
        this.writer.setOutputOrdinates(Ordinate.createXY());
    }

    public void testReadNaN() throws Exception {
        String pt = "POINT (10 10)";
        WKTReadWriteTest.assertEquals((String)"POINT (10 10)", (String)this.writer.write(this.reader.read("POINT (10 10 NaN)")));
        WKTReadWriteTest.assertEquals((String)"POINT (10 10)", (String)this.writer.write(this.reader.read("POINT (10 10 nan)")));
        WKTReadWriteTest.assertEquals((String)"POINT (10 10)", (String)this.writer.write(this.reader.read("POINT (10 10 NAN)")));
    }

    public void testReadPoint() throws Exception {
        WKTReadWriteTest.assertEquals((String)"POINT (10 10)", (String)this.writer.write(this.reader.read("POINT (10 10)")));
        WKTReadWriteTest.assertEquals((String)"POINT EMPTY", (String)this.writer.write(this.reader.read("POINT EMPTY")));
    }

    public void testReadLineString() throws Exception {
        WKTReadWriteTest.assertEquals((String)"LINESTRING (10 10, 20 20, 30 40)", (String)this.writer.write(this.reader.read("LINESTRING (10 10, 20 20, 30 40)")));
        WKTReadWriteTest.assertEquals((String)"LINESTRING EMPTY", (String)this.writer.write(this.reader.read("LINESTRING EMPTY")));
    }

    public void testReadLinearRing() throws Exception {
        try {
            this.reader.read("LINEARRING (10 10, 20 20, 30 40, 10 99)");
        }
        catch (IllegalArgumentException e) {
            WKTReadWriteTest.assertTrue((boolean)e.getMessage().contains("not form a closed linestring"));
        }
        WKTReadWriteTest.assertEquals((String)"LINEARRING (10 10, 20 20, 30 40, 10 10)", (String)this.writer.write(this.reader.read("LINEARRING (10 10, 20 20, 30 40, 10 10)")));
        WKTReadWriteTest.assertEquals((String)"LINEARRING EMPTY", (String)this.writer.write(this.reader.read("LINEARRING EMPTY")));
    }

    public void testReadPolygon() throws Exception {
        WKTReadWriteTest.assertEquals((String)"POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10))", (String)this.writer.write(this.reader.read("POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10))")));
        WKTReadWriteTest.assertEquals((String)"POLYGON EMPTY", (String)this.writer.write(this.reader.read("POLYGON EMPTY")));
    }

    public void testReadMultiPoint() throws Exception {
        WKTReadWriteTest.assertEquals((String)"MULTIPOINT ((10 10), (20 20))", (String)this.writer.write(this.reader.read("MULTIPOINT ((10 10), (20 20))")));
        WKTReadWriteTest.assertEquals((String)"MULTIPOINT EMPTY", (String)this.writer.write(this.reader.read("MULTIPOINT EMPTY")));
        WKTReadWriteTest.assertEquals((String)"MULTIPOINT (EMPTY, EMPTY)", (String)this.writer.write(this.reader.read("MULTIPOINT (EMPTY, EMPTY)")));
    }

    public void testReadMultiLineString() throws Exception {
        WKTReadWriteTest.assertEquals((String)"MULTILINESTRING ((10 10, 20 20), (15 15, 30 15))", (String)this.writer.write(this.reader.read("MULTILINESTRING ((10 10, 20 20), (15 15, 30 15))")));
        WKTReadWriteTest.assertEquals((String)"MULTILINESTRING EMPTY", (String)this.writer.write(this.reader.read("MULTILINESTRING EMPTY")));
        WKTReadWriteTest.assertEquals((String)"MULTILINESTRING (EMPTY, EMPTY)", (String)this.writer.write(this.reader.read("MULTILINESTRING (EMPTY, EMPTY)")));
    }

    public void testReadMultiPolygon() throws Exception {
        WKTReadWriteTest.assertEquals((String)"MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10)), ((60 60, 70 70, 80 60, 60 60)))", (String)this.writer.write(this.reader.read("MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10)), ((60 60, 70 70, 80 60, 60 60)))")));
        WKTReadWriteTest.assertEquals((String)"MULTIPOLYGON EMPTY", (String)this.writer.write(this.reader.read("MULTIPOLYGON EMPTY")));
        WKTReadWriteTest.assertEquals((String)"MULTIPOLYGON (EMPTY, EMPTY)", (String)this.writer.write(this.reader.read("MULTIPOLYGON (EMPTY, EMPTY)")));
    }

    public void testReadGeometryCollection() throws Exception {
        WKTReadWriteTest.assertEquals((String)"GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))", (String)this.writer.write(this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))")));
        WKTReadWriteTest.assertEquals((String)"GEOMETRYCOLLECTION (POINT (10 10), LINEARRING EMPTY, LINESTRING (15 15, 20 20))", (String)this.writer.write(this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), LINEARRING EMPTY, LINESTRING (15 15, 20 20))")));
        WKTReadWriteTest.assertEquals((String)"GEOMETRYCOLLECTION (POINT (10 10), LINEARRING (10 10, 20 20, 30 40, 10 10), LINESTRING (15 15, 20 20))", (String)this.writer.write(this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), LINEARRING (10 10, 20 20, 30 40, 10 10), LINESTRING (15 15, 20 20))")));
        WKTReadWriteTest.assertEquals((String)"GEOMETRYCOLLECTION EMPTY", (String)this.writer.write(this.reader.read("GEOMETRYCOLLECTION EMPTY")));
    }

    public void testReadGeometryCollectionEmptyWithElements() throws Exception {
        WKTReadWriteTest.assertEquals((String)"GEOMETRYCOLLECTION (POINT EMPTY)", (String)this.writer.write(this.reader.read("GEOMETRYCOLLECTION ( POINT EMPTY )")));
        WKTReadWriteTest.assertEquals((String)"GEOMETRYCOLLECTION (POINT EMPTY, LINESTRING EMPTY)", (String)this.writer.write(this.reader.read("GEOMETRYCOLLECTION ( POINT EMPTY, LINESTRING EMPTY )")));
    }
}

