/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.util.Locale;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.io.OrdinateFormat;

public class OrdinateFormatTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(OrdinateFormatTest.class);
    }

    public OrdinateFormatTest(String name) {
        super(name);
    }

    public void testLargeNumber() {
        this.checkFormat(1.23456789E9, "1234567890");
    }

    public void testVeryLargeNumber() {
        this.checkFormat(1.2345678901234567E19, "12345678901234567000");
    }

    public void testDecimalPoint() {
        this.checkFormat(1.123, "1.123");
    }

    public void testNegative() {
        this.checkFormat(-1.123, "-1.123");
    }

    public void testFractionDigits() {
        this.checkFormat(1.123456789012345, "1.123456789012345");
        this.checkFormat(0.0123456789012345, "0.0123456789012345");
    }

    public void testLimitedFractionDigits2() {
        this.checkFormat(1.123456789012345, 2, "1.12");
        this.checkFormat(1.123456789012345, 3, "1.123");
        this.checkFormat(1.123456789012345, 4, "1.1235");
        this.checkFormat(1.123456789012345, 5, "1.12346");
        this.checkFormat(1.123456789012345, 6, "1.123457");
    }

    public void testMaximumFractionDigits() {
        this.checkFormat(1.23456789012345E-11, "0.0000000000123456789012345");
    }

    public void testPi() {
        this.checkFormat(Math.PI, "3.141592653589793");
    }

    public void testNaN() {
        this.checkFormat(Double.NaN, "NaN");
    }

    public void testInf() {
        this.checkFormat(Double.POSITIVE_INFINITY, "Inf");
        this.checkFormat(Double.NEGATIVE_INFINITY, "-Inf");
    }

    private void checkFormat(double d, String expected) {
        String actual = OrdinateFormat.DEFAULT.format(d);
        OrdinateFormatTest.assertEquals((String)expected, (String)actual);
    }

    private void checkFormat(double d, int maxFractionDigits, String expected) {
        OrdinateFormat format = OrdinateFormat.create(maxFractionDigits);
        String actual = format.format(d);
        OrdinateFormatTest.assertEquals((String)expected, (String)actual);
    }

    private void checkFormatAllLocales(double d, int maxFractionDigits, String expected) {
        OrdinateFormat format = OrdinateFormat.create(maxFractionDigits);
        String actual = format.format(d);
        OrdinateFormatTest.assertEquals((String)expected, (String)actual);
    }

    private void checkFormatLocales(Locale locale, double d, int maxFractionDigits, String expected) {
        OrdinateFormat format = OrdinateFormat.create(maxFractionDigits);
        String actual = format.format(d);
        OrdinateFormatTest.assertEquals((String)expected, (String)actual);
    }
}

