/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.io.Serializable;
import java.util.Comparator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class GeometryDistanceComparator
implements Comparator<Geometry>,
Serializable {
    boolean normalOrder;
    Point queryCenter;

    public GeometryDistanceComparator(Point queryCenter, boolean normalOrder) {
        this.queryCenter = queryCenter;
        this.normalOrder = normalOrder;
    }

    @Override
    public int compare(Geometry g1, Geometry g2) {
        double distance1 = g1.getEnvelopeInternal().distance(this.queryCenter.getEnvelopeInternal());
        double distance2 = g2.getEnvelopeInternal().distance(this.queryCenter.getEnvelopeInternal());
        if (this.normalOrder) {
            if (distance1 > distance2) {
                return 1;
            }
            if (distance1 == distance2) {
                return 0;
            }
            return -1;
        }
        if (distance1 > distance2) {
            return -1;
        }
        if (distance1 == distance2) {
            return 0;
        }
        return 1;
    }
}

