/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.io.ParseException;
import test.jts.GeometryTestCase;

public class GeometryMapperTest
extends GeometryTestCase {
    static GeometryMapper.MapOp KEEP_LINE = new GeometryMapper.MapOp(){

        @Override
        public Geometry map(Geometry geom) {
            if (geom instanceof Point) {
                return geom.getFactory().createEmpty(1);
            }
            if (geom instanceof LineString) {
                return geom;
            }
            return null;
        }
    };
    static GeometryMapper.MapOp BOUNDARY = new GeometryMapper.MapOp(){

        @Override
        public Geometry map(Geometry geom) {
            return geom.getBoundary();
        }
    };

    public static void main(String[] args) {
        TestRunner.run(GeometryMapperTest.class);
    }

    public GeometryMapperTest(String name) {
        super(name);
    }

    public void testFlatMapInputEmpty() throws ParseException {
        this.checkFlatMap("GEOMETRYCOLLECTION( POINT EMPTY, LINESTRING EMPTY)", 1, KEEP_LINE, "LINESTRING EMPTY");
    }

    public void testFlatMapInputMulti() throws ParseException {
        this.checkFlatMap("GEOMETRYCOLLECTION( MULTILINESTRING((0 0, 1 1), (1 1, 2 2)), LINESTRING(2 2, 3 3))", 1, KEEP_LINE, "MULTILINESTRING ((0 0, 1 1), (1 1, 2 2), (2 2, 3 3))");
    }

    public void testFlatMapResultEmpty() throws ParseException {
        this.checkFlatMap("GEOMETRYCOLLECTION( LINESTRING(0 0, 1 1), LINESTRING(1 1, 2 2))", 1, KEEP_LINE, "MULTILINESTRING((0 0, 1 1), (1 1, 2 2))");
        this.checkFlatMap("GEOMETRYCOLLECTION( POINT(0 0), POINT(0 0), LINESTRING(0 0, 1 1))", 1, KEEP_LINE, "LINESTRING(0 0, 1 1)");
        this.checkFlatMap("MULTIPOINT((0 0), (1 1))", 1, KEEP_LINE, "LINESTRING EMPTY");
    }

    public void testFlatMapResultNull() throws ParseException {
        this.checkFlatMap("GEOMETRYCOLLECTION( POINT(0 0), LINESTRING(0 0, 1 1), POLYGON ((1 1, 1 2, 2 1, 1 1)))", 1, KEEP_LINE, "LINESTRING(0 0, 1 1)");
    }

    public void testFlatMapBoundary() throws ParseException {
        this.checkFlatMap("GEOMETRYCOLLECTION( POINT(0 0), LINESTRING(0 0, 1 1), POLYGON ((1 1, 1 2, 2 1, 1 1)))", 0, BOUNDARY, "GEOMETRYCOLLECTION (POINT (0 0), POINT (1 1), LINEARRING (1 1, 1 2, 2 1, 1 1))");
        this.checkFlatMap("LINESTRING EMPTY", 0, BOUNDARY, "POINT EMPTY");
    }

    private void checkFlatMap(String wkt, int dim, GeometryMapper.MapOp op, String wktExpected) {
        Geometry geom = this.read(wkt);
        Geometry actual = GeometryMapper.flatMap(geom, dim, op);
        Geometry expected = this.read(wktExpected);
        this.checkEqual(expected, actual);
    }
}

