/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.GeometryFixer;
import test.jts.GeometryTestCase;

public class GeometryFixerTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(GeometryFixerTest.class);
    }

    public GeometryFixerTest(String name) {
        super(name);
    }

    public void testPoint() {
        this.checkFix("POINT (0 0)", "POINT (0 0)");
    }

    public void testPointNaN() {
        this.checkFix("POINT (0 Nan)", "POINT EMPTY");
    }

    public void testPointEmpty() {
        this.checkFix("POINT EMPTY", "POINT EMPTY");
    }

    public void testPointPosInf() {
        this.checkFix(this.createPoint(0.0, Double.POSITIVE_INFINITY), "POINT EMPTY");
    }

    public void testPointNegInf() {
        this.checkFix(this.createPoint(0.0, Double.POSITIVE_INFINITY), "POINT EMPTY");
    }

    private Point createPoint(double x, double y) {
        Coordinate p = new Coordinate(x, y);
        Point pt = this.getGeometryFactory().createPoint(p);
        return pt;
    }

    public void testMultiPointNaN() {
        this.checkFix("MULTIPOINT ((0 Nan))", "MULTIPOINT EMPTY");
    }

    public void testMultiPoint() {
        this.checkFix("MULTIPOINT ((0 0), (1 1))", "MULTIPOINT ((0 0), (1 1))");
    }

    public void testMultiPointWithEmptyKeepMulti() {
        this.checkFix("MULTIPOINT ((0 0), EMPTY)", "MULTIPOINT ((0 0))", true);
    }

    public void testMultiPointWithEmpty() {
        this.checkFix("MULTIPOINT ((0 0), EMPTY)", "POINT (0 0)", false);
    }

    public void testMultiPointWithMultiEmpty() {
        this.checkFix("MULTIPOINT (EMPTY, EMPTY)", "MULTIPOINT EMPTY");
    }

    public void testLineStringEmpty() {
        this.checkFix("LINESTRING EMPTY", "LINESTRING EMPTY");
    }

    public void testLineStringCollapse() {
        this.checkFix("LINESTRING (0 0, 1 NaN, 0 0)", "LINESTRING EMPTY");
    }

    public void testLineStringCollapseMultipleRepeated() {
        this.checkFix("LINESTRING (0 0, 0 0, 0 0)", "LINESTRING EMPTY");
    }

    public void testLineStringKeepCollapse() {
        this.checkFixKeepCollapse("LINESTRING (0 0, 0 0, 0 0)", "POINT (0 0)");
    }

    public void testLineStringRepeated() {
        this.checkFix("LINESTRING (0 0, 0 0, 0 0, 0 0, 0 0, 1 1)", "LINESTRING (0 0, 1 1)");
    }

    public void testLineStringSelfCross() {
        this.checkFix("LINESTRING (0 0, 9 9, 9 5, 0 5)", "LINESTRING (0 0, 9 9, 9 5, 0 5)");
    }

    public void testLinearRingEmpty() {
        this.checkFix("LINEARRING EMPTY", "LINEARRING EMPTY");
    }

    public void testLinearRingCollapsePoint() {
        this.checkFix("LINEARRING (0 0, 1 NaN, 0 0)", "LINEARRING EMPTY");
    }

    public void testLinearRingCollapseLine() {
        this.checkFix("LINEARRING (0 0, 1 NaN, 1 0, 0 0)", "LINEARRING EMPTY");
    }

    public void testLinearRingKeepCollapsePoint() {
        this.checkFixKeepCollapse("LINEARRING (0 0, 1 NaN, 0 0)", "POINT (0 0)");
    }

    public void testLinearRingKeepCollapseLine() {
        this.checkFixKeepCollapse("LINEARRING (0 0, 1 NaN, 1 0, 0 0)", "LINESTRING (0 0, 1 0, 0 0)");
    }

    public void testLinearRingValid() {
        this.checkFix("LINEARRING (10 10, 10 90, 90 90, 90 10, 10 10)", "LINEARRING (10 10, 10 90, 90 90, 90 10, 10 10)");
    }

    public void testLinearRingFlat() {
        this.checkFix("LINEARRING (10 10, 10 90, 90 90, 10 90, 10 10)", "LINESTRING (10 10, 10 90, 90 90, 10 90, 10 10)");
    }

    public void testLinearRingSelfCross() {
        this.checkFix("LINEARRING (10 10, 10 90, 90 10, 90 90, 10 10)", "LINESTRING (10 10, 10 90, 90 10, 90 90, 10 10)");
    }

    public void testMultiLineStringSelfCross() {
        this.checkFix("MULTILINESTRING ((10 90, 90 10, 90 90), (90 50, 10 50))", "MULTILINESTRING ((10 90, 90 10, 90 90), (90 50, 10 50))");
    }

    public void testMultiLineStringWithCollapse() {
        this.checkFix("MULTILINESTRING ((10 10, 90 90), (10 10, 10 10, 10 10))", "LINESTRING (10 10, 90 90))", false);
    }

    public void testMultiLineStringWithCollapseKeepMulti() {
        this.checkFix("MULTILINESTRING ((10 10, 90 90), (10 10, 10 10, 10 10))", "MULTILINESTRING ((10 10, 90 90)))", true);
    }

    public void testMultiLineStringKeepCollapse() {
        this.checkFixKeepCollapse("MULTILINESTRING ((10 10, 90 90), (10 10, 10 10, 10 10))", "GEOMETRYCOLLECTION (POINT (10 10), LINESTRING (10 10, 90 90))");
    }

    public void testMultiLineStringWithEmpty() {
        this.checkFix("MULTILINESTRING ((10 10, 90 90), EMPTY)", "MULTILINESTRING ((10 10, 90 90))");
    }

    public void testMultiLineStringWithMultiEmpty() {
        this.checkFix("MULTILINESTRING (EMPTY, EMPTY)", "MULTILINESTRING EMPTY");
    }

    public void testPolygonEmpty() {
        this.checkFix("POLYGON EMPTY", "POLYGON EMPTY");
    }

    public void testPolygonBowtie() {
        this.checkFix("POLYGON ((10 90, 90 10, 90 90, 10 10, 10 90))", "MULTIPOLYGON (((10 90, 50 50, 10 10, 10 90)), ((50 50, 90 90, 90 10, 50 50)))");
    }

    public void testPolygonHolesZeroAreaOverlapping() {
        this.checkFix("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (80 70, 30 70, 30 20, 30 70, 80 70), (70 80, 70 30, 20 30, 70 30, 70 80))", "POLYGON ((90 90, 90 10, 10 10, 10 90, 90 90))");
    }

    public void testPolygonPosAndNegOverlap() {
        this.checkFix("POLYGON ((10 90, 50 90, 50 30, 70 30, 70 50, 30 50, 30 70, 90 70, 90 10, 10 10, 10 90))", "POLYGON ((10 90, 50 90, 50 70, 90 70, 90 10, 10 10, 10 90), (50 50, 50 30, 70 30, 70 50, 50 50))");
    }

    public void testHolesTouching() {
        this.checkFix("POLYGON ((0 0, 0 5, 6 5, 6 0, 0 0), (3 1, 4 1, 4 2, 3 2, 3 1), (3 2, 1 4, 5 4, 4 2, 4 3, 3 2, 2 3, 3 2))", "MULTIPOLYGON (((0 0, 0 5, 6 5, 6 0, 0 0), (1 4, 2 3, 3 2, 3 1, 4 1, 4 2, 5 4, 1 4)), ((3 2, 4 3, 4 2, 3 2)))");
    }

    public void testPolygonNaN() {
        this.checkFix("POLYGON ((10 90, 90 NaN, 90 10, 10 10, 10 90))", "POLYGON ((10 10, 10 90, 90 10, 10 10))");
    }

    public void testPolygonRepeated() {
        this.checkFix("POLYGON ((10 90, 90 10, 90 10, 90 10, 90 10, 90 10, 10 10, 10 90))", "POLYGON ((10 10, 10 90, 90 10, 10 10))");
    }

    public void testPolygonShellCollapse() {
        this.checkFix("POLYGON ((10 10, 10 90, 90 90, 10 90, 10 10), (20 80, 60 80, 60 40, 20 40, 20 80))", "POLYGON EMPTY");
    }

    public void testPolygonShellCollapseNaN() {
        this.checkFix("POLYGON ((10 10, 10 NaN, 90 NaN, 10 NaN, 10 10))", "POLYGON EMPTY");
    }

    public void testPolygonShellKeepCollapseNaN() {
        this.checkFixKeepCollapse("POLYGON ((10 10, 10 NaN, 90 NaN, 10 NaN, 10 10))", "POINT (10 10)");
    }

    public void testPolygonShellKeepCollapse() {
        this.checkFixKeepCollapse("POLYGON ((10 10, 10 90, 90 90, 10 90, 10 10), (20 80, 60 80, 60 40, 20 40, 20 80))", "LINESTRING (10 10, 10 90, 90 90, 10 90, 10 10)");
    }

    public void testPolygonHoleCollapse() {
        this.checkFix("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (80 80, 20 80, 20 20, 20 80, 80 80))", "POLYGON ((10 10, 10 90, 90 90, 90 10, 10 10))");
    }

    public void testPolygonHoleKeepCollapse() {
        this.checkFixKeepCollapse("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (80 80, 20 80, 20 20, 20 80, 80 80))", "POLYGON ((10 10, 10 90, 90 90, 90 10, 10 10))");
    }

    public void testPolygonHoleOverlapAndOutsideOverlap() {
        this.checkFix("POLYGON ((50 90, 80 90, 80 10, 50 10, 50 90), (70 80, 90 80, 90 20, 70 20, 70 80), (40 80, 40 50, 0 50, 0 80, 40 80), (30 40, 10 40, 10 60, 30 60, 30 40), (60 70, 80 70, 80 30, 60 30, 60 70))", "MULTIPOLYGON (((10 40, 10 50, 0 50, 0 80, 40 80, 40 50, 30 50, 30 40, 10 40)), ((70 80, 70 70, 60 70, 60 30, 70 30, 70 20, 80 20, 80 10, 50 10, 50 90, 80 90, 80 80, 70 80)))");
    }

    public void testMultiPolygonEmpty() {
        this.checkFix("MULTIPOLYGON EMPTY", "MULTIPOLYGON EMPTY");
    }

    public void testMultiPolygonMultiEmpty() {
        this.checkFix("MULTIPOLYGON (EMPTY, EMPTY)", "MULTIPOLYGON EMPTY");
    }

    public void testMultiPolygonWithEmpty() {
        this.checkFix("MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), EMPTY, ((50 40, 80 40, 80 10, 50 10, 50 40)))", "MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), ((50 40, 80 40, 80 10, 50 10, 50 40)))");
    }

    public void testMultiPolygonWithCollapseKeepMulti() {
        this.checkFix("MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), ((50 40, 50 40, 50 40, 50 40, 50 40)))", "MULTIPOLYGON (((10 10, 10 40, 40 40, 40 10, 10 10)))", true);
    }

    public void testMultiPolygonWithCollapse() {
        this.checkFix("MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), ((50 40, 50 40, 50 40, 50 40, 50 40)))", "POLYGON ((10 10, 10 40, 40 40, 40 10, 10 10))", false);
    }

    public void testMultiPolygonKeepCollapse() {
        this.checkFixKeepCollapse("MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), ((50 40, 50 40, 50 40, 50 40, 50 40)))", "GEOMETRYCOLLECTION (POINT (50 40), POLYGON ((10 10, 10 40, 40 40, 40 10, 10 10)))");
    }

    public void testGCEmpty() {
        this.checkFix("GEOMETRYCOLLECTION EMPTY", "GEOMETRYCOLLECTION EMPTY");
    }

    public void testGCWithAllEmpty() {
        this.checkFix("GEOMETRYCOLLECTION (POINT EMPTY, LINESTRING EMPTY, POLYGON EMPTY)", "GEOMETRYCOLLECTION (POINT EMPTY, LINESTRING EMPTY, POLYGON EMPTY)");
    }

    public void testGCKeepCollapse() {
        this.checkFixKeepCollapse("GEOMETRYCOLLECTION (LINESTRING ( 0 0, 0 0), POINT (1 1))", "GEOMETRYCOLLECTION (POINT (0 0), POINT (1 1))");
    }

    public void testPolygonZBowtie() {
        this.checkFixZ("POLYGON Z ((10 90 1, 90 10 9, 90 90 9, 10 10 1, 10 90 1))", "MULTIPOLYGON Z (((10 10 1, 10 90 1, 50 50 5, 10 10 1)), ((50 50 5, 90 90 9, 90 10 9, 50 50 5)))");
    }

    public void testPolygonZHoleOverlap() {
        this.checkFixZ("POLYGON Z ((10 90 1, 60 90 6, 60 10 6, 10 10 1, 10 90 1), (20 80 2, 90 80 9, 90 20 9, 20 20 2, 20 80 2))", "POLYGON Z ((10 10 1, 10 90 1, 60 90 6, 60 80 6, 20 80 2, 20 20 2, 60 20 6, 60 10 6, 10 10 1))");
    }

    public void testMultiLineStringZKeepCollapse() {
        this.checkFixZKeepCollapse("MULTILINESTRING Z ((10 10 1, 90 90 9), (10 10 1, 10 10 2, 10 10 3))", "GEOMETRYCOLLECTION Z (POINT (10 10 1), LINESTRING (10 10 1, 90 90 9))");
    }

    public void testIssue852Case1() {
        this.checkFix("POLYGON ((42.565844354657436 -72.61247966084643, 42.56484510561062 -72.61202938126273, 42.56384585656381 -72.61247966084643, 42.563637679679054 -72.61276108558623, 42.562055535354936 -72.61366164475362, 42.5631796905326 -72.61259223074235, 42.565844354657436 -72.61214195115866, 42.566510520688645 -72.61259223074235, 42.565844354657436 -72.61247966084643))");
    }

    public void testIssue852Case2() {
        this.checkFix("POLYGON ((50.69544005538049 4.587126197745181, 50.699035986722194 4.592752502415541, 50.699395579856365 4.592049214331746, 50.699125885005735 4.590501980547397, 50.69867639358802 4.591064611014433, 50.69795720731968 4.591064611014433, 50.69759761418551 4.590501980547397, 50.69759761418551 4.589376719613325, 50.69831680045385 4.588251458679252, 50.69723802105134 4.586563567278144, 50.69579964851466 4.586563567278144, 50.69544005538049 4.587126197745181))");
    }

    private void checkFix(String wkt) {
        Geometry geom = this.read(wkt);
        Geometry fix = GeometryFixer.fix(geom);
        GeometryFixerTest.assertTrue((String)"Result is invalid", (boolean)fix.isValid());
    }

    private void checkFix(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFix(geom, false, true, wktExpected);
    }

    private void checkFix(String wkt, String wktExpected, boolean keepMulti) {
        Geometry geom = this.read(wkt);
        this.checkFix(geom, false, keepMulti, wktExpected);
    }

    private void checkFixKeepCollapse(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFix(geom, true, true, wktExpected);
    }

    private void checkFix(Geometry input, String wktExpected) {
        this.checkFix(input, false, true, wktExpected);
    }

    private void checkFixKeepCollapse(Geometry input, String wktExpected) {
        this.checkFix(input, true, true, wktExpected);
    }

    private void checkFix(Geometry input, boolean keepCollapse, boolean keepMulti, String wktExpected) {
        Geometry actual;
        if (keepCollapse) {
            GeometryFixer fixer = new GeometryFixer(input);
            fixer.setKeepCollapsed(true);
            fixer.setKeepMulti(keepMulti);
            actual = fixer.getResult();
        } else {
            actual = GeometryFixer.fix(input, keepMulti);
        }
        GeometryFixerTest.assertTrue((String)"Result is invalid", (boolean)actual.isValid());
        GeometryFixerTest.assertTrue((String)"Input geometry was not copied", (input != actual ? 1 : 0) != 0);
        GeometryFixerTest.assertTrue((String)"Result has aliased coordinates", (boolean)this.checkDeepCopy(input, actual));
        Geometry expected = this.read(wktExpected);
        this.checkEqual(expected, actual);
    }

    private boolean checkDeepCopy(Geometry geom1, Geometry geom2) {
        Coordinate[] pts2;
        Coordinate[] pts1 = geom1.getCoordinates();
        for (Coordinate p2 : pts2 = geom2.getCoordinates()) {
            if (!this.isIn(p2, pts1)) continue;
            return false;
        }
        return true;
    }

    private boolean isIn(Coordinate p, Coordinate[] pts) {
        for (int i = 0; i < pts.length; ++i) {
            if (p != pts[i]) continue;
            return true;
        }
        return false;
    }

    private void checkFixZ(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFixZ(geom, false, wktExpected);
    }

    private void checkFixZKeepCollapse(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFixZ(geom, true, wktExpected);
    }

    private void checkFixZ(Geometry input, boolean keepCollapse, String wktExpected) {
        Geometry actual;
        if (keepCollapse) {
            GeometryFixer fixer = new GeometryFixer(input);
            fixer.setKeepCollapsed(true);
            actual = fixer.getResult();
        } else {
            actual = GeometryFixer.fix(input);
        }
        GeometryFixerTest.assertTrue((String)"Result is invalid", (boolean)actual.isValid());
        Geometry expected = this.read(wktExpected);
        this.checkEqualXYZ(expected, actual);
    }
}

