/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import junit.framework.TestCase;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.AffineTransformationBuilder;
import org.locationtech.jts.geom.util.AffineTransformationFactory;

public class AffineTransformationBuilderTest
extends TestCase {
    private Coordinate ctl0 = new Coordinate(-10.0, -10.0);
    private Coordinate ctl1 = new Coordinate(10.0, 20.0);
    private Coordinate ctl2 = new Coordinate(10.0, -20.0);

    public AffineTransformationBuilderTest(String name) {
        super(name);
    }

    public void testRotate1() {
        this.run(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0);
    }

    public void testRotate2() {
        this.run(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, -1.0, 1.0);
    }

    public void testScale1() {
        this.run(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 2.0);
    }

    public void testTranslate1() {
        this.run(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 5.0, 6.0, 6.0, 6.0, 5.0, 7.0);
    }

    public void testLinear1() {
        this.run(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 5.0, 7.0);
    }

    public void testSingular2() {
        this.runSingular(0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 0.0, 0.0, 10.0, 10.0, 30.0, 30.0);
    }

    public void testSingular3() {
        this.runSingular(0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 0.0, 0.0, 10.0, 10.0, 20.0, 20.0);
    }

    public void testSingular1() {
        this.runSingular(0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 0.0, 0.0, 1.0, 2.0, 1.0, 3.0);
    }

    public void testSingleControl1() {
        this.run(0.0, 0.0, 5.0, 6.0);
    }

    public void testDualControl_Translation() {
        this.run(0.0, 0.0, 1.0, 1.0, 5.0, 5.0, 6.0, 6.0);
    }

    public void testDualControl_General() {
        this.run(0.0, 0.0, 1.0, 1.0, 5.0, 5.0, 6.0, 9.0);
    }

    void run(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double pp0x, double pp0y, double pp1x, double pp1y, double pp2x, double pp2y) {
        Coordinate p0 = new Coordinate(p0x, p0y);
        Coordinate p1 = new Coordinate(p1x, p1y);
        Coordinate p2 = new Coordinate(p2x, p2y);
        Coordinate pp0 = new Coordinate(pp0x, pp0y);
        Coordinate pp1 = new Coordinate(pp1x, pp1y);
        Coordinate pp2 = new Coordinate(pp2x, pp2y);
        AffineTransformationBuilder atb = new AffineTransformationBuilder(p0, p1, p2, pp0, pp1, pp2);
        AffineTransformation trans = atb.getTransformation();
        Coordinate dest = new Coordinate();
        this.assertEqualPoint(pp0, trans.transform(p0, dest));
        this.assertEqualPoint(pp1, trans.transform(p1, dest));
        this.assertEqualPoint(pp2, trans.transform(p2, dest));
    }

    void run(double p0x, double p0y, double p1x, double p1y, double pp0x, double pp0y, double pp1x, double pp1y) {
        Coordinate p0 = new Coordinate(p0x, p0y);
        Coordinate p1 = new Coordinate(p1x, p1y);
        Coordinate pp0 = new Coordinate(pp0x, pp0y);
        Coordinate pp1 = new Coordinate(pp1x, pp1y);
        AffineTransformation trans = AffineTransformationFactory.createFromControlVectors(p0, p1, pp0, pp1);
        Coordinate dest = new Coordinate();
        this.assertEqualPoint(pp0, trans.transform(p0, dest));
        this.assertEqualPoint(pp1, trans.transform(p1, dest));
    }

    void run(double p0x, double p0y, double pp0x, double pp0y) {
        Coordinate p0 = new Coordinate(p0x, p0y);
        Coordinate pp0 = new Coordinate(pp0x, pp0y);
        AffineTransformation trans = AffineTransformationFactory.createFromControlVectors(p0, pp0);
        Coordinate dest = new Coordinate();
        this.assertEqualPoint(pp0, trans.transform(p0, dest));
    }

    void runSingular(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double pp0x, double pp0y, double pp1x, double pp1y, double pp2x, double pp2y) {
        Coordinate p0 = new Coordinate(p0x, p0y);
        Coordinate p1 = new Coordinate(p1x, p1y);
        Coordinate p2 = new Coordinate(p2x, p2y);
        Coordinate pp0 = new Coordinate(pp0x, pp0y);
        Coordinate pp1 = new Coordinate(pp1x, pp1y);
        Coordinate pp2 = new Coordinate(pp2x, pp2y);
        AffineTransformationBuilder atb = new AffineTransformationBuilder(p0, p1, p2, pp0, pp1, pp2);
        AffineTransformation trans = atb.getTransformation();
        AffineTransformationBuilderTest.assertEquals((Object)trans, null);
    }

    public void testTransform1() {
        AffineTransformation trans = new AffineTransformation();
        trans.rotate(1.0);
        trans.translate(10.0, 10.0);
        trans.scale(2.0, 2.0);
        this.runTransform(trans, this.ctl0, this.ctl1, this.ctl2);
    }

    public void testTransform2() {
        AffineTransformation trans = new AffineTransformation();
        trans.rotate(3.0);
        trans.translate(10.0, 10.0);
        trans.scale(2.0, 10.0);
        trans.shear(5.0, 2.0);
        trans.reflect(5.0, 8.0, 10.0, 2.0);
        this.runTransform(trans, this.ctl0, this.ctl1, this.ctl2);
    }

    private void runTransform(AffineTransformation trans, Coordinate p0, Coordinate p1, Coordinate p2) {
        Coordinate pp0 = trans.transform(p0, new Coordinate());
        Coordinate pp1 = trans.transform(p1, new Coordinate());
        Coordinate pp2 = trans.transform(p2, new Coordinate());
        AffineTransformationBuilder atb = new AffineTransformationBuilder(p0, p1, p2, pp0, pp1, pp2);
        AffineTransformation atbTrans = atb.getTransformation();
        Coordinate dest = new Coordinate();
        this.assertEqualPoint(pp0, atbTrans.transform(p0, dest));
        this.assertEqualPoint(pp1, atbTrans.transform(p1, dest));
        this.assertEqualPoint(pp2, atbTrans.transform(p2, dest));
    }

    private void assertEqualPoint(Coordinate p, Coordinate q) {
        AffineTransformationBuilderTest.assertEquals((double)p.x, (double)q.x, (double)5.0E-5);
        AffineTransformationBuilderTest.assertEquals((double)p.y, (double)q.y, (double)5.0E-5);
    }
}

