/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.SineStarFactory;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.GeometricShapeFactory;

public abstract class StressTestHarness {
    static final int MAX_ITER = 10000;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    private int numTargetPts = 1000;

    public void setTargetSize(int nPts) {
        this.numTargetPts = nPts;
    }

    public void run(int nIter) {
        Geometry poly = this.createSineStar(new Coordinate(0.0, 0.0), 100.0, this.numTargetPts);
        this.run(nIter, poly);
    }

    Geometry createCircle(Coordinate origin, double size, int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Polygon circle = gsf.createCircle();
        return circle;
    }

    Geometry createSineStar(Coordinate origin, double size, int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        gsf.setArmLengthRatio(0.1);
        gsf.setNumArms(20);
        Geometry poly = gsf.createSineStar();
        return poly;
    }

    Geometry createRandomTestGeometry(Envelope env, double size, int nPts) {
        double width = env.getWidth();
        double xOffset = width * Math.random();
        double yOffset = env.getHeight() * Math.random();
        Coordinate basePt = new Coordinate(env.getMinX() + xOffset, env.getMinY() + yOffset);
        Geometry test = this.createTestCircle(basePt, size, nPts);
        if (test instanceof Polygon && Math.random() > 0.5) {
            test = test.getBoundary();
        }
        return test;
    }

    Geometry createTestCircle(Coordinate base, double size, int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(base);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Polygon circle = gsf.createCircle();
        return circle;
    }

    public void run(int nIter, Geometry target) {
        for (int count = 0; count < nIter; ++count) {
            Geometry test = this.createRandomTestGeometry(target.getEnvelopeInternal(), 10.0, 20);
            boolean isResultCorrect = this.checkResult(target, test);
            if (isResultCorrect) continue;
            throw new RuntimeException("Invalid result found");
        }
    }

    public abstract boolean checkResult(Geometry var1, Geometry var2);
}

