/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.impl.CoordinateSequenceTestBase;

public class CoordinateArraySequenceTest
extends CoordinateSequenceTestBase {
    public static void main(String[] args) {
        TestRunner.run(CoordinateArraySequenceTest.class);
    }

    public CoordinateArraySequenceTest(String name) {
        super(name);
    }

    @Override
    CoordinateArraySequenceFactory getCSFactory() {
        return CoordinateArraySequenceFactory.instance();
    }

    public void testFactoryLimits() {
        CoordinateArraySequenceFactory factory = this.getCSFactory();
        CoordinateSequence sequence = factory.create(10, 4);
        CoordinateArraySequenceTest.assertEquals((String)"clipped dimension 3", (int)3, (int)sequence.getDimension());
        CoordinateArraySequenceTest.assertEquals((String)"default measure   0", (int)0, (int)sequence.getMeasures());
        CoordinateArraySequenceTest.assertTrue((boolean)sequence.hasZ());
        CoordinateArraySequenceTest.assertTrue((!sequence.hasM() ? 1 : 0) != 0);
        sequence = factory.create(10, 4, 0);
        CoordinateArraySequenceTest.assertEquals((String)"clipped dimension 3", (int)3, (int)sequence.getDimension());
        CoordinateArraySequenceTest.assertEquals((String)"provided measure  0", (int)0, (int)sequence.getMeasures());
        CoordinateArraySequenceTest.assertTrue((boolean)sequence.hasZ());
        CoordinateArraySequenceTest.assertTrue((!sequence.hasM() ? 1 : 0) != 0);
        sequence = factory.create(10, 4, 2);
        CoordinateArraySequenceTest.assertEquals((String)"clipped dimension 3", (int)3, (int)sequence.getDimension());
        CoordinateArraySequenceTest.assertEquals((String)"clipped measure   1", (int)1, (int)sequence.getMeasures());
        CoordinateArraySequenceTest.assertTrue((!sequence.hasZ() ? 1 : 0) != 0);
        CoordinateArraySequenceTest.assertTrue((boolean)sequence.hasM());
        sequence = factory.create(10, 5, 1);
        CoordinateArraySequenceTest.assertEquals((String)"clipped dimension 3", (int)4, (int)sequence.getDimension());
        CoordinateArraySequenceTest.assertEquals((String)"provided measure  1", (int)1, (int)sequence.getMeasures());
        CoordinateArraySequenceTest.assertTrue((boolean)sequence.hasZ());
        CoordinateArraySequenceTest.assertTrue((boolean)sequence.hasM());
        sequence = factory.create(10, 1);
        CoordinateArraySequenceTest.assertEquals((String)"clipped dimension 2", (int)2, (int)sequence.getDimension());
        CoordinateArraySequenceTest.assertEquals((String)"default measure   0", (int)0, (int)sequence.getMeasures());
        CoordinateArraySequenceTest.assertTrue((!sequence.hasZ() ? 1 : 0) != 0);
        CoordinateArraySequenceTest.assertTrue((!sequence.hasM() ? 1 : 0) != 0);
        sequence = factory.create(10, 2, 1);
        CoordinateArraySequenceTest.assertEquals((String)"clipped dimension 3", (int)3, (int)sequence.getDimension());
        CoordinateArraySequenceTest.assertEquals((String)"provided measure  1", (int)1, (int)sequence.getMeasures());
        CoordinateArraySequenceTest.assertTrue((!sequence.hasZ() ? 1 : 0) != 0);
        CoordinateArraySequenceTest.assertTrue((boolean)sequence.hasM());
    }

    public void testDimensionAndMeasure() {
        CoordinateArraySequenceFactory factory = this.getCSFactory();
        CoordinateSequence seq = factory.create(5, 2);
        this.initProgression(seq);
        CoordinateArraySequenceTest.assertEquals((String)"xz", (int)2, (int)seq.getDimension());
        CoordinateArraySequenceTest.assertTrue((String)"Z", (!seq.hasZ() ? 1 : 0) != 0);
        CoordinateArraySequenceTest.assertTrue((String)"M", (!seq.hasM() ? 1 : 0) != 0);
        Coordinate coord = seq.getCoordinate(4);
        CoordinateArraySequenceTest.assertTrue((boolean)(coord instanceof CoordinateXY));
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        Coordinate[] array = seq.toCoordinateArray();
        CoordinateArraySequenceTest.assertEquals((Object)coord, (Object)array[4]);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        CoordinateSequence copy = factory.create(array);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        copy = factory.create(seq);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        seq = factory.create(5, 3);
        this.initProgression(seq);
        CoordinateArraySequenceTest.assertEquals((String)"xyz", (int)3, (int)seq.getDimension());
        CoordinateArraySequenceTest.assertTrue((String)"Z", (boolean)seq.hasZ());
        CoordinateArraySequenceTest.assertTrue((String)"M", (!seq.hasM() ? 1 : 0) != 0);
        coord = seq.getCoordinate(4);
        CoordinateArraySequenceTest.assertTrue((coord.getClass() == Coordinate.class ? 1 : 0) != 0);
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getZ());
        array = seq.toCoordinateArray();
        CoordinateArraySequenceTest.assertEquals((Object)coord, (Object)array[4]);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        copy = factory.create(array);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        copy = factory.create(seq);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        seq = factory.create(5, 3, 1);
        this.initProgression(seq);
        CoordinateArraySequenceTest.assertEquals((String)"xym", (int)3, (int)seq.getDimension());
        CoordinateArraySequenceTest.assertTrue((String)"Z", (!seq.hasZ() ? 1 : 0) != 0);
        CoordinateArraySequenceTest.assertTrue((String)"M", (boolean)seq.hasM());
        coord = seq.getCoordinate(4);
        CoordinateArraySequenceTest.assertTrue((boolean)(coord instanceof CoordinateXYM));
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getM());
        array = seq.toCoordinateArray();
        CoordinateArraySequenceTest.assertEquals((Object)coord, (Object)array[4]);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        copy = factory.create(array);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        copy = factory.create(seq);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        seq = factory.create(5, 4, 1);
        this.initProgression(seq);
        CoordinateArraySequenceTest.assertEquals((String)"xyzm", (int)4, (int)seq.getDimension());
        CoordinateArraySequenceTest.assertTrue((String)"Z", (boolean)seq.hasZ());
        CoordinateArraySequenceTest.assertTrue((String)"M", (boolean)seq.hasM());
        coord = seq.getCoordinate(4);
        CoordinateArraySequenceTest.assertTrue((boolean)(coord instanceof CoordinateXYZM));
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getX());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getY());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getZ());
        CoordinateArraySequenceTest.assertEquals((Object)4.0, (Object)coord.getM());
        array = seq.toCoordinateArray();
        CoordinateArraySequenceTest.assertEquals((Object)coord, (Object)array[4]);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(seq, array));
        copy = factory.create(array);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        copy = factory.create(seq);
        CoordinateArraySequenceTest.assertTrue((boolean)this.isEqual(copy, array));
        seq = factory.create(5, 2, 1);
        CoordinateArraySequenceTest.assertEquals((int)3, (int)seq.getDimension());
        CoordinateArraySequenceTest.assertEquals((int)1, (int)seq.getMeasures());
    }

    public void testMixedCoordinates() {
        CoordinateArraySequenceFactory factory = this.getCSFactory();
        Coordinate coord1 = new Coordinate(1.0, 1.0, 1.0);
        CoordinateXY coord2 = new CoordinateXY(2.0, 2.0);
        CoordinateXYM coord3 = new CoordinateXYM(3.0, 3.0, 3.0);
        Coordinate[] array = new Coordinate[]{coord1, coord2, coord3, null};
        CoordinateSequence seq = factory.create(array);
        CoordinateArraySequenceTest.assertEquals((int)3, (int)seq.getDimension());
        CoordinateArraySequenceTest.assertEquals((int)1, (int)seq.getMeasures());
        CoordinateArraySequenceTest.assertTrue((boolean)coord1.equals(seq.getCoordinate(0)));
        CoordinateArraySequenceTest.assertTrue((boolean)coord2.equals(seq.getCoordinate(1)));
        CoordinateArraySequenceTest.assertTrue((boolean)coord3.equals(seq.getCoordinate(2)));
        CoordinateArraySequenceTest.assertNull((Object)seq.getCoordinate(3));
    }

    private void initProgression(CoordinateSequence seq) {
        for (int index = 0; index < seq.size(); ++index) {
            for (int ordinateIndex = 0; ordinateIndex < seq.getDimension(); ++ordinateIndex) {
                seq.setOrdinate(index, ordinateIndex, index);
            }
        }
    }
}

