/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.io.WKTWriter;
import test.jts.GeometryTestCase;

public class TriangleCircumcentreTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(TriangleCircumcentreTest.class);
    }

    public TriangleCircumcentreTest(String name) {
        super(name);
    }

    public void testSquareDiagonalDD() {
        Coordinate cc1 = TriangleCircumcentreTest.circumcentreDD(193600.80333333334, 469345.355, 193600.80333333334, 469345.0175, 193601.10666666666, 469345.0175);
        Coordinate cc2 = TriangleCircumcentreTest.circumcentreDD(193600.80333333334, 469345.355, 193601.10666666666, 469345.0175, 193601.10666666666, 469345.355);
        this.checkCCEqual(cc1, cc2);
    }

    private static Coordinate circumcentre(double ax, double ay, double bx, double by, double cx, double cy) {
        Coordinate a = new Coordinate(ax, ay);
        Coordinate b = new Coordinate(bx, by);
        Coordinate c = new Coordinate(cx, cy);
        return Triangle.circumcentre(a, b, c);
    }

    private static Coordinate circumcentreDD(double ax, double ay, double bx, double by, double cx, double cy) {
        Coordinate a = new Coordinate(ax, ay);
        Coordinate b = new Coordinate(bx, by);
        Coordinate c = new Coordinate(cx, cy);
        return Triangle.circumcentreDD(a, b, c);
    }

    private void checkCCEqual(Coordinate cc1, Coordinate cc2) {
        boolean isEqual = cc1.equals2D(cc2);
        if (!isEqual) {
            System.out.println("Triangle circumcentres are not equal!");
            System.out.println(WKTWriter.toPoint(cc1));
            System.out.println(WKTWriter.toPoint(cc2));
        }
        TriangleCircumcentreTest.assertTrue((boolean)isEqual);
    }
}

