/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTReader;

public class RectanglePredicateTest
extends TestCase {
    private WKTReader rdr = new WKTReader();
    private GeometryFactory fact = new GeometryFactory();

    public static void main(String[] args) {
        TestRunner.run(RectanglePredicateTest.class);
    }

    public RectanglePredicateTest(String name) {
        super(name);
    }

    public void testShortAngleOnBoundary() throws Exception {
        String[] onBoundary = new String[]{"POLYGON ((10 10, 30 10, 30 30, 10 30, 10 10))", "LINESTRING (10 25, 10 10, 25 10)"};
        this.runRectanglePred(onBoundary);
    }

    public void testAngleOnBoundary() throws Exception {
        String[] onBoundary = new String[]{"POLYGON ((10 10, 30 10, 30 30, 10 30, 10 10))", "LINESTRING (10 30, 10 10, 30 10)"};
        this.runRectanglePred(onBoundary);
    }

    private void runRectanglePred(String[] wkt) throws Exception {
        Geometry rect = this.rdr.read(wkt[0]);
        Geometry b = this.rdr.read(wkt[1]);
        this.runRectanglePred(rect, b);
    }

    private void runRectanglePred(Geometry rect, Geometry testGeom) {
        boolean containsOK;
        boolean relateIntersectsValue;
        boolean intersectsValue = rect.intersects(testGeom);
        boolean intersectsOK = intersectsValue == (relateIntersectsValue = rect.relate(testGeom).isIntersects());
        boolean containsValue = rect.contains(testGeom);
        boolean relateContainsValue = rect.relate(testGeom).isContains();
        boolean bl = containsOK = containsValue == relateContainsValue;
        if (!intersectsOK || !containsOK) {
            // empty if block
        }
        RectanglePredicateTest.assertTrue((boolean)intersectsOK);
        RectanglePredicateTest.assertTrue((boolean)containsOK);
    }
}

