/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;

public class PointImplTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1000.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run((Test)PointImplTest.suite());
    }

    public PointImplTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PointImplTest.class);
    }

    public void testEquals1() throws Exception {
        Point p1 = (Point)this.reader.read("POINT(1.234 5.678)");
        Point p2 = (Point)this.reader.read("POINT(1.234 5.678)");
        PointImplTest.assertTrue((boolean)p1.equals(p2));
    }

    public void testEquals2() throws Exception {
        Point p1 = (Point)this.reader.read("POINT(1.23 5.67)");
        Point p2 = (Point)this.reader.read("POINT(1.23 5.67)");
        PointImplTest.assertTrue((boolean)p1.equals(p2));
    }

    public void testEquals3() throws Exception {
        Point p2;
        Point p1 = (Point)this.reader.read("POINT(1.235 5.678)");
        PointImplTest.assertTrue((!p1.equals(p2 = (Point)this.reader.read("POINT(1.234 5.678)")) ? 1 : 0) != 0);
    }

    public void testEquals4() throws Exception {
        Point p1 = (Point)this.reader.read("POINT(1.2334 5.678)");
        Point p2 = (Point)this.reader.read("POINT(1.2333 5.678)");
        PointImplTest.assertTrue((boolean)p1.equals(p2));
    }

    public void testEquals5() throws Exception {
        Point p2;
        Point p1 = (Point)this.reader.read("POINT(1.2334 5.678)");
        PointImplTest.assertTrue((!p1.equals(p2 = (Point)this.reader.read("POINT(1.2335 5.678)")) ? 1 : 0) != 0);
    }

    public void testEquals6() throws Exception {
        Point p2;
        Point p1 = (Point)this.reader.read("POINT(1.2324 5.678)");
        PointImplTest.assertTrue((!p1.equals(p2 = (Point)this.reader.read("POINT(1.2325 5.678)")) ? 1 : 0) != 0);
    }

    public void testNegRounding1() throws Exception {
        Point pLo = (Point)this.reader.read("POINT(-1.233 5.678)");
        Point pHi = (Point)this.reader.read("POINT(-1.232 5.678)");
        Point p1 = (Point)this.reader.read("POINT(-1.2326 5.678)");
        Point p2 = (Point)this.reader.read("POINT(-1.2325 5.678)");
        Point p3 = (Point)this.reader.read("POINT(-1.2324 5.678)");
        PointImplTest.assertTrue((!p1.equals(p2) ? 1 : 0) != 0);
        PointImplTest.assertTrue((boolean)p3.equals(p2));
        PointImplTest.assertTrue((boolean)p1.equals(pLo));
        PointImplTest.assertTrue((boolean)p2.equals(pHi));
        PointImplTest.assertTrue((boolean)p3.equals(pHi));
    }

    public void testIsSimple() throws Exception {
        Point p1 = (Point)this.reader.read("POINT(1.2324 5.678)");
        PointImplTest.assertTrue((boolean)p1.isSimple());
        Point p2 = (Point)this.reader.read("POINT EMPTY");
        PointImplTest.assertTrue((boolean)p2.isSimple());
    }
}

