/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.locationtech.jts.geom.IntersectionMatrix;

public class IntersectionMatrixTest
extends TestCase {
    private static int A = 2;
    private static int L = 1;
    private static int P = 0;

    public IntersectionMatrixTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IntersectionMatrixTest.class);
    }

    public void testToString() throws Exception {
        IntersectionMatrix i = new IntersectionMatrix();
        i.set("012*TF012");
        IntersectionMatrixTest.assertEquals((String)"012*TF012", (String)i.toString());
        IntersectionMatrix c = new IntersectionMatrix(i);
        IntersectionMatrixTest.assertEquals((String)"012*TF012", (String)c.toString());
    }

    public void testTranspose() {
        IntersectionMatrix x = new IntersectionMatrix("012*TF012");
        IntersectionMatrix i = new IntersectionMatrix(x);
        IntersectionMatrix j = i.transpose();
        IntersectionMatrixTest.assertSame((Object)i, (Object)j);
        IntersectionMatrixTest.assertEquals((String)"0*01T12F2", (String)i.toString());
        IntersectionMatrixTest.assertEquals((String)"012*TF012", (String)x.toString());
    }

    public void testIsDisjoint() {
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("FF*FF****").isDisjoint());
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("FF1FF2T*0").isDisjoint());
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("*F*FF****").isDisjoint() ? 1 : 0) != 0);
    }

    public void testIsTouches() {
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("FT*******").isTouches(P, A));
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("FT*******").isTouches(A, P));
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("FT*******").isTouches(P, P) ? 1 : 0) != 0);
    }

    public void testIsIntersects() {
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("FF*FF****").isIntersects() ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("FF1FF2T*0").isIntersects() ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("*F*FF****").isIntersects());
    }

    public void testIsCrosses() {
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("TFTFFFFFF").isCrosses(P, L));
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("TFTFFFFFF").isCrosses(L, P) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("TFFFFFTFF").isCrosses(P, L) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("TFFFFFTFF").isCrosses(L, P));
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("0FFFFFFFF").isCrosses(L, L));
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("1FFFFFFFF").isCrosses(L, L) ? 1 : 0) != 0);
    }

    public void testIsWithin() {
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("T0F00F000").isWithin());
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("T00000FF0").isWithin() ? 1 : 0) != 0);
    }

    public void testIsContains() {
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("T0F00F000").isContains() ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("T00000FF0").isContains());
    }

    public void testIsOverlaps() {
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("2*2***2**").isOverlaps(P, P));
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("2*2***2**").isOverlaps(A, A));
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("2*2***2**").isOverlaps(P, A) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("2*2***2**").isOverlaps(L, L) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("1*2***2**").isOverlaps(L, L));
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("0FFFFFFF2").isOverlaps(P, P) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("1FFF0FFF2").isOverlaps(L, L) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("2FFF1FFF2").isOverlaps(A, A) ? 1 : 0) != 0);
    }

    public void testIsEquals() {
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("0FFFFFFF2").isEquals(P, P));
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("1FFF0FFF2").isEquals(L, L));
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("2FFF1FFF2").isEquals(A, A));
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("0F0FFFFF2").isEquals(P, P) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((boolean)new IntersectionMatrix("1FFF1FFF2").isEquals(L, L));
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("2FFF1*FF2").isEquals(A, A) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("0FFFFFFF2").isEquals(P, L) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("1FFF0FFF2").isEquals(L, A) ? 1 : 0) != 0);
        IntersectionMatrixTest.assertTrue((!new IntersectionMatrix("2FFF1FFF2").isEquals(A, P) ? 1 : 0) != 0);
    }
}

