/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryOverlay;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import test.jts.GeometryTestCase;

public class GeometryOverlayTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(GeometryOverlayTest.class);
    }

    public GeometryOverlayTest(String name) {
        super(name);
    }

    public void testOverlayNGFixed() {
        GeometryOverlay.setOverlayImpl(GeometryOverlay.OVERLAY_PROPERTY_VALUE_NG);
        PrecisionModel pmFixed = new PrecisionModel(1.0);
        Geometry expected = this.read("POLYGON ((1 2, 4 1, 1 1, 1 2))");
        this.checkIntersectionPM(pmFixed, expected);
    }

    public void testOverlayNGFloat() {
        GeometryOverlay.setOverlayImpl(GeometryOverlay.OVERLAY_PROPERTY_VALUE_NG);
        PrecisionModel pmFloat = new PrecisionModel();
        Geometry expected = this.read("POLYGON ((1 1, 1 2, 4 1.25, 4 1, 1 1))");
        this.checkIntersectionPM(pmFloat, expected);
    }

    private void checkIntersectionPM(PrecisionModel pmFixed, Geometry expected) {
        GeometryFactory geomFactFixed = new GeometryFactory(pmFixed);
        Geometry a = GeometryOverlayTest.read(geomFactFixed, "POLYGON ((1 1, 1 2, 5 1, 1 1))");
        Geometry b = GeometryOverlayTest.read(geomFactFixed, "POLYGON ((0 3, 4 3, 4 0, 0 0, 0 3))");
        Geometry actual = a.intersection(b);
        this.checkEqual(expected, actual);
    }

    public void testOverlayOld() {
        GeometryOverlay.setOverlayImpl(GeometryOverlay.OVERLAY_PROPERTY_VALUE_OLD);
        this.checkIntersectionFails();
    }

    public void testOverlayNG() {
        GeometryOverlay.setOverlayImpl(GeometryOverlay.OVERLAY_PROPERTY_VALUE_NG);
        this.checkIntersectionSucceeds();
    }

    private void checkIntersectionFails() {
        try {
            this.tryIntersection();
            GeometryOverlayTest.fail((String)"Intersection operation should have failed but did not");
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
    }

    private void checkIntersectionSucceeds() {
        try {
            this.tryIntersection();
        }
        catch (TopologyException ex) {
            GeometryOverlayTest.fail((String)"Intersection operation failed.");
        }
    }

    private void tryIntersection() {
        Geometry a = this.read("POLYGON ((-1120500.000000126 850931.058865365, -1120500.0000001257 851343.3885007716, -1120500.0000001257 851342.2386007707, -1120399.762684411 851199.4941312922, -1120500.000000126 850931.058865365))");
        Geometry b = this.read("POLYGON ((-1120500.000000126 851253.4627870625, -1120500.0000001257 851299.8179383819, -1120492.1498410008 851293.8417889411, -1120500.000000126 851253.4627870625))");
        Geometry result = a.intersection(b);
    }
}

