/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.edgegraph.EdgeGraph;
import org.locationtech.jts.edgegraph.EdgeGraphBuilder;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import test.jts.util.IOUtil;

public class EdgeGraphTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(EdgeGraphTest.class);
    }

    public EdgeGraphTest(String name) {
        super(name);
    }

    public void testNode() throws Exception {
        EdgeGraph graph = this.build("MULTILINESTRING((0 0, 1 0), (0 0, 0 1), (0 0, -1 0))");
        this.checkEdgeRing(graph, new Coordinate(0.0, 0.0), new Coordinate[]{new Coordinate(1.0, 0.0), new Coordinate(0.0, 1.0), new Coordinate(-1.0, 0.0)});
        this.checkNodeValid(graph, new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0));
        this.checkEdge(graph, new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0));
        this.checkNextPrev(graph);
        this.checkNext(graph, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.checkNext(graph, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0);
        this.checkNext(graph, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        this.checkNextPrev(graph, 1.0, 0.0, 0.0, 0.0);
        this.checkNextPrev(graph, 0.0, 1.0, 0.0, 0.0);
        this.checkNextPrev(graph, -1.0, 0.0, 0.0, 0.0);
        EdgeGraphTest.assertTrue((this.findEdge(graph, 0.0, 0.0, 1.0, 0.0).degree() == 3 ? 1 : 0) != 0);
    }

    public void testRingGraph() throws Exception {
        EdgeGraph graph = this.build("MULTILINESTRING ((10 10, 10 90), (10 90, 90 90), (90 90, 90 10), (90 10, 10 10))");
        HalfEdge e = this.findEdge(graph, 10.0, 10.0, 10.0, 90.0);
        HalfEdge eNext = this.findEdge(graph, 10.0, 90.0, 90.0, 90.0);
        EdgeGraphTest.assertTrue((e.next() == eNext ? 1 : 0) != 0);
        EdgeGraphTest.assertTrue((eNext.prev() == e ? 1 : 0) != 0);
        HalfEdge eSym = this.findEdge(graph, 10.0, 90.0, 10.0, 10.0);
        EdgeGraphTest.assertTrue((e.sym() == eSym ? 1 : 0) != 0);
        EdgeGraphTest.assertTrue((boolean)e.orig().equals2D(new Coordinate(10.0, 10.0)));
        EdgeGraphTest.assertTrue((boolean)e.dest().equals2D(new Coordinate(10.0, 90.0)));
        this.checkNextPrev(graph);
    }

    public void testSingleEdgeGraph() throws Exception {
        EdgeGraph graph = this.build("LINESTRING (10 10, 20 20)");
        this.checkNextPrev(graph);
    }

    public void testCCWAfterInserts() {
        EdgeGraph graph = new EdgeGraph();
        HalfEdge e1 = this.addEdge(graph, 50.0, 39.0, 35.0, 42.0);
        this.addEdge(graph, 50.0, 39.0, 50.0, 60.0);
        this.addEdge(graph, 50.0, 39.0, 68.0, 35.0);
        this.checkNodeValid(e1);
    }

    public void testCCWAfterInserts2() {
        EdgeGraph graph = new EdgeGraph();
        HalfEdge e1 = this.addEdge(graph, 50.0, 200.0, 0.0, 200.0);
        this.addEdge(graph, 50.0, 200.0, 190.0, 50.0);
        this.addEdge(graph, 50.0, 200.0, 200.0, 200.0);
        this.checkNodeValid(e1);
    }

    private void checkEdgeRing(EdgeGraph graph, Coordinate p, Coordinate[] dest) {
        HalfEdge e;
        HalfEdge onext = e = graph.findEdge(p, dest[0]);
        int i = 0;
        do {
            EdgeGraphTest.assertTrue((boolean)onext.dest().equals2D(dest[i++]));
        } while ((onext = onext.oNext()) != e);
    }

    private void checkEdge(EdgeGraph graph, Coordinate p0, Coordinate p1) {
        HalfEdge e = graph.findEdge(p0, p1);
        EdgeGraphTest.assertNotNull((Object)e);
    }

    private void checkNodeValid(EdgeGraph graph, Coordinate p0, Coordinate p1) {
        HalfEdge e = graph.findEdge(p0, p1);
        boolean isNodeValid = e.isEdgesSorted();
        EdgeGraphTest.assertTrue((String)("Found non-sorted edges around node " + e), (boolean)isNodeValid);
    }

    private void checkNodeValid(HalfEdge e) {
        boolean isNodeValid = e.isEdgesSorted();
        EdgeGraphTest.assertTrue((String)("Found non-sorted edges around node " + e), (boolean)isNodeValid);
    }

    private void checkNextPrev(EdgeGraph graph) {
        Collection edges = graph.getVertexEdges();
        for (HalfEdge e : edges) {
            EdgeGraphTest.assertTrue((e.next().prev() == e ? 1 : 0) != 0);
        }
    }

    private void checkNext(EdgeGraph graph, double x1, double y1, double x2, double y2, double x3, double y3) {
        HalfEdge e1 = this.findEdge(graph, x1, y1, x2, y2);
        HalfEdge e2 = this.findEdge(graph, x2, y2, x3, y3);
        EdgeGraphTest.assertTrue((e1.next() == e2 ? 1 : 0) != 0);
        EdgeGraphTest.assertTrue((e2.prev() == e1 ? 1 : 0) != 0);
    }

    private void checkNextPrev(EdgeGraph graph, double x1, double y1, double x2, double y2) {
        HalfEdge e = this.findEdge(graph, x1, y1, x2, y2);
        EdgeGraphTest.assertTrue((e.next().prev() == e ? 1 : 0) != 0);
    }

    private HalfEdge findEdge(EdgeGraph graph, double x1, double y1, double x2, double y2) {
        return graph.findEdge(new Coordinate(x1, y1), new Coordinate(x2, y2));
    }

    private EdgeGraph build(String wkt) throws ParseException {
        return this.build(new String[]{wkt});
    }

    private EdgeGraph build(String[] wkt) throws ParseException {
        List<Geometry> geoms = IOUtil.readWKT(wkt);
        return EdgeGraphBuilder.build(geoms);
    }

    private HalfEdge addEdge(EdgeGraph graph, double p0x, double p0y, double p1x, double p1y) {
        return graph.addEdge(new Coordinate(p0x, p0y), new Coordinate(p1x, p1y));
    }
}

