/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import junit.framework.TestCase;
import org.junit.Test;
import org.locationtech.jts.algorithm.distance.DiscreteFrechetDistance;

public class MatrixStorageTest
extends TestCase {
    @Test
    public void testCsrMatrix() {
        DiscreteFrechetDistance.CsrMatrix mat = new DiscreteFrechetDistance.CsrMatrix(4, 6, 0.0, 8);
        MatrixStorageTest.runOrderedTest(mat);
        mat = new DiscreteFrechetDistance.CsrMatrix(4, 6, 0.0, 8);
        MatrixStorageTest.runUnorderedTest(mat);
    }

    @Test
    public void testHashMapMatrix() {
        DiscreteFrechetDistance.HashMapMatrix mat = new DiscreteFrechetDistance.HashMapMatrix(4, 6, 0.0);
        MatrixStorageTest.runOrderedTest(mat);
        mat = new DiscreteFrechetDistance.HashMapMatrix(4, 6, 0.0);
        MatrixStorageTest.runUnorderedTest(mat);
    }

    @Test
    public void testRectMatrix() {
        DiscreteFrechetDistance.RectMatrix mat = new DiscreteFrechetDistance.RectMatrix(4, 6, 0.0);
        MatrixStorageTest.runOrderedTest(mat);
        mat = new DiscreteFrechetDistance.RectMatrix(4, 6, 0.0);
        MatrixStorageTest.runUnorderedTest(mat);
    }

    private static void runOrderedTest(DiscreteFrechetDistance.MatrixStorage mat) {
        mat.set(0, 0, 10.0);
        mat.set(0, 1, 20.0);
        mat.set(1, 1, 30.0);
        mat.set(1, 3, 40.0);
        mat.set(2, 2, 50.0);
        mat.set(2, 3, 60.0);
        mat.set(2, 4, 70.0);
        mat.set(3, 5, 80.0);
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 0, 0, 10.0, mat.get(0, 0)), (Object)10.0, (Object)mat.get(0, 0));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 0, 1, 20.0, mat.get(0, 1)), (Object)20.0, (Object)mat.get(0, 1));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 1, 1, 30.0, mat.get(1, 1)), (Object)30.0, (Object)mat.get(1, 1));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 1, 3, 40.0, mat.get(1, 3)), (Object)40.0, (Object)mat.get(1, 3));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 2, 2, 50.0, mat.get(2, 2)), (Object)50.0, (Object)mat.get(2, 2));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 2, 3, 60.0, mat.get(2, 3)), (Object)60.0, (Object)mat.get(2, 3));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 2, 4, 70.0, mat.get(2, 4)), (Object)70.0, (Object)mat.get(2, 4));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 3, 5, 80.0, mat.get(3, 5)), (Object)80.0, (Object)mat.get(3, 5));
    }

    private static void runUnorderedTest(DiscreteFrechetDistance.MatrixStorage mat) {
        mat.set(0, 0, 10.0);
        mat.set(3, 5, 80.0);
        mat.set(0, 1, 20.0);
        mat.set(2, 4, 70.0);
        mat.set(1, 1, 30.0);
        mat.set(2, 3, 60.0);
        mat.set(2, 2, 50.0);
        mat.set(1, 3, 40.0);
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 0, 0, 10.0, mat.get(0, 0)), (Object)10.0, (Object)mat.get(0, 0));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 0, 1, 20.0, mat.get(0, 1)), (Object)20.0, (Object)mat.get(0, 1));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 1, 1, 30.0, mat.get(1, 1)), (Object)30.0, (Object)mat.get(1, 1));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 1, 3, 40.0, mat.get(1, 3)), (Object)40.0, (Object)mat.get(1, 3));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 2, 2, 50.0, mat.get(2, 2)), (Object)50.0, (Object)mat.get(2, 2));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 2, 3, 60.0, mat.get(2, 3)), (Object)60.0, (Object)mat.get(2, 3));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 2, 4, 70.0, mat.get(2, 4)), (Object)70.0, (Object)mat.get(2, 4));
        MatrixStorageTest.assertEquals((String)String.format("%1$d -> %2$d = %4$f /= %3$f", 3, 5, 80.0, mat.get(3, 5)), (Object)80.0, (Object)mat.get(3, 5));
    }
}

