/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class RobustLineIntersectionTest
extends TestCase {
    private WKTReader reader = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(RobustLineIntersectionTest.class);
    }

    public RobustLineIntersectionTest(String name) {
        super(name);
    }

    public void testCentralEndpointHeuristicFailure() throws ParseException {
        this.checkIntersection("LINESTRING (163.81867067 -211.31840378, 165.9174252 -214.1665075)", "LINESTRING (2.84139601 -57.95412726, 469.59990601 -502.63851732)", 1, "POINT (163.81867067 -211.31840378)", 0.0);
    }

    public void testCentralEndpointHeuristicFailure2() throws ParseException {
        this.checkIntersection("LINESTRING (-58.00593335955 -1.43739086465, -513.86101637525 -457.29247388035)", "LINESTRING (-215.22279674875 -158.65425425385, -218.1208801283 -160.68343590235)", 1, "POINT ( -215.22279674875 -158.65425425385 )", 0.0);
    }

    public void testRoundedPointsNotAltered() throws ParseException {
        this.checkInputNotAltered("LINESTRING (-58.00593335955 -1.43739086465, -513.86101637525 -457.29247388035)", "LINESTRING (-215.22279674875 -158.65425425385, -218.1208801283 -160.68343590235)", 100000);
    }

    public void testTomasFa_1() throws ParseException {
        this.checkIntersectionNone("LINESTRING (-42.0 163.2, 21.2 265.2)", "LINESTRING (-26.2 188.7, 37.0 290.7)");
    }

    public void testTomasFa_2() throws ParseException {
        this.checkIntersectionNone("LINESTRING (-5.9 163.1, 76.1 250.7)", "LINESTRING (14.6 185.0, 96.6 272.6)");
    }

    public void testLeduc_1() throws ParseException {
        this.checkIntersection("LINESTRING (305690.0434123494 254176.46578338774, 305601.9999843455 254243.19999846347)", "LINESTRING (305689.6153764265 254177.33102743194, 305692.4999844298 254171.4999983967)", 1, "POINT (305690.0434123494 254176.46578338774)", 0.0);
    }

    public void testGEOS_1() throws ParseException {
        this.checkIntersection("LINESTRING (588750.7429703881 4518950.493668233, 588748.2060409798 4518933.9452804085)", "LINESTRING (588745.824857241 4518940.742239175, 588748.2060437313 4518933.9452791475)", 1, "POINT (588748.2060416829 4518933.945284994)", 0.0);
    }

    public void testGEOS_2() throws ParseException {
        this.checkIntersection("LINESTRING (588743.626135934 4518924.610969561, 588732.2822865889 4518925.4314047815)", "LINESTRING (588739.1191384895 4518927.235700594, 588731.7854614238 4518924.578370095)", 1, "POINT (588733.8306132929 4518925.319423238)", 0.0);
    }

    public void testDaveSkeaCase() throws ParseException {
        this.checkIntersection("LINESTRING ( 2089426.5233462777 1180182.3877339689, 2085646.6891757075 1195618.7333999649 )", "LINESTRING ( 1889281.8148903656 1997547.0560044837, 2259977.3672235999 483675.17050843034 )", 1, new Coordinate[]{new Coordinate(2087536.6062609926, 1187900.560566967)}, 0.0);
    }

    public void testCmp5CaseWKT() throws ParseException {
        this.checkIntersection("LINESTRING (4348433.262114629 5552595.478385733, 4348440.849387404 5552599.272022122 )", "LINESTRING (4348433.26211463  5552595.47838573,  4348440.8493874   5552599.27202212  )", 1, new Coordinate[]{new Coordinate(4348440.8493874, 5552599.27202212)}, 0.0);
    }

    public void testCmp5CaseRaw() throws ParseException {
        this.checkIntersection(new Coordinate[]{new Coordinate(4348433.262114629, 5552595.478385733), new Coordinate(4348440.849387404, 5552599.272022122), new Coordinate(4348433.26211463, 5552595.47838573), new Coordinate(4348440.8493874, 5552599.27202212)}, 1, new Coordinate[]{new Coordinate(4348440.8493874, 5552599.27202212)}, 0.0);
    }

    void checkIntersectionNone(String wkt1, String wkt2) throws ParseException {
        LineString l1 = (LineString)this.reader.read(wkt1);
        LineString l2 = (LineString)this.reader.read(wkt2);
        Coordinate[] pt = new Coordinate[]{l1.getCoordinateN(0), l1.getCoordinateN(1), l2.getCoordinateN(0), l2.getCoordinateN(1)};
        this.checkIntersection(pt, 0, null, 0.0);
    }

    void checkIntersection(String wkt1, String wkt2, int expectedIntersectionNum, Coordinate[] intPt, double distanceTolerance) throws ParseException {
        LineString l1 = (LineString)this.reader.read(wkt1);
        LineString l2 = (LineString)this.reader.read(wkt2);
        Coordinate[] pt = new Coordinate[]{l1.getCoordinateN(0), l1.getCoordinateN(1), l2.getCoordinateN(0), l2.getCoordinateN(1)};
        this.checkIntersection(pt, expectedIntersectionNum, intPt, distanceTolerance);
    }

    void checkIntersection(String wkt1, String wkt2, int expectedIntersectionNum, String expectedWKT, double distanceTolerance) throws ParseException {
        LineString l1 = (LineString)this.reader.read(wkt1);
        LineString l2 = (LineString)this.reader.read(wkt2);
        Coordinate[] pt = new Coordinate[]{l1.getCoordinateN(0), l1.getCoordinateN(1), l2.getCoordinateN(0), l2.getCoordinateN(1)};
        Geometry g = this.reader.read(expectedWKT);
        Coordinate[] intPt = g.getCoordinates();
        this.checkIntersection(pt, expectedIntersectionNum, intPt, distanceTolerance);
    }

    void checkIntersection(Coordinate[] pt, int expectedIntersectionNum, Coordinate[] expectedIntPt, double distanceTolerance) {
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(pt[0], pt[1], pt[2], pt[3]);
        int intNum = li.getIntersectionNum();
        RobustLineIntersectionTest.assertEquals((String)"Number of intersections not as expected", (int)expectedIntersectionNum, (int)intNum);
        if (expectedIntPt != null) {
            RobustLineIntersectionTest.assertEquals((String)"Wrong number of expected int pts provided", (int)intNum, (int)expectedIntPt.length);
            boolean isIntPointsCorrect = true;
            if (intNum == 1) {
                this.checkIntPoints(expectedIntPt[0], li.getIntersection(0), distanceTolerance);
            } else if (intNum == 2) {
                this.checkIntPoints(expectedIntPt[1], li.getIntersection(0), distanceTolerance);
                this.checkIntPoints(expectedIntPt[1], li.getIntersection(0), distanceTolerance);
                if (!RobustLineIntersectionTest.equals(expectedIntPt[0], li.getIntersection(0), distanceTolerance) && !RobustLineIntersectionTest.equals(expectedIntPt[0], li.getIntersection(1), distanceTolerance)) {
                    this.checkIntPoints(expectedIntPt[0], li.getIntersection(0), distanceTolerance);
                    this.checkIntPoints(expectedIntPt[0], li.getIntersection(1), distanceTolerance);
                } else if (!RobustLineIntersectionTest.equals(expectedIntPt[1], li.getIntersection(0), distanceTolerance) && !RobustLineIntersectionTest.equals(expectedIntPt[1], li.getIntersection(1), distanceTolerance)) {
                    this.checkIntPoints(expectedIntPt[1], li.getIntersection(0), distanceTolerance);
                    this.checkIntPoints(expectedIntPt[1], li.getIntersection(1), distanceTolerance);
                }
            }
        }
    }

    void checkIntPoints(Coordinate expectedPt, Coordinate actualPt, double distanceTolerance) {
        boolean isEqual = RobustLineIntersectionTest.equals(expectedPt, actualPt, distanceTolerance);
        RobustLineIntersectionTest.assertTrue((String)("Int Pts not equal - expected " + WKTWriter.toPoint(expectedPt) + " VS actual " + WKTWriter.toPoint(actualPt)), (boolean)isEqual);
    }

    public static boolean equals(Coordinate p0, Coordinate p1, double distanceTolerance) {
        return p0.distance(p1) <= distanceTolerance;
    }

    void checkInputNotAltered(String wkt1, String wkt2, int scaleFactor) throws ParseException {
        LineString l1 = (LineString)this.reader.read(wkt1);
        LineString l2 = (LineString)this.reader.read(wkt2);
        Coordinate[] pt = new Coordinate[]{l1.getCoordinateN(0), l1.getCoordinateN(1), l2.getCoordinateN(0), l2.getCoordinateN(1)};
        this.checkInputNotAltered(pt, scaleFactor);
    }

    public void checkInputNotAltered(Coordinate[] pt, int scaleFactor) {
        Coordinate[] savePt = new Coordinate[4];
        for (int i = 0; i < 4; ++i) {
            savePt[i] = new Coordinate(pt[i]);
        }
        RobustLineIntersector li = new RobustLineIntersector();
        li.setPrecisionModel(new PrecisionModel(scaleFactor));
        li.computeIntersection(pt[0], pt[1], pt[2], pt[3]);
        for (int i = 0; i < 4; ++i) {
            RobustLineIntersectionTest.assertEquals((String)("Input point " + i + " was altered - "), (Object)savePt[i], (Object)pt[i]);
        }
    }
}

