/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.AbstractPointInRingTest;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.WKTReader;

public class RayCrossingCounterTest
extends AbstractPointInRingTest {
    private WKTReader reader = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(RayCrossingCounterTest.class);
    }

    public RayCrossingCounterTest(String name) {
        super(name);
    }

    @Override
    protected void runPtInRing(int expectedLoc, Coordinate pt, String wkt) throws Exception {
        Geometry geom = this.reader.read(wkt);
        RayCrossingCounterTest.assertEquals((int)expectedLoc, (int)RayCrossingCounter.locatePointInRing(pt, geom.getCoordinates()));
    }

    public void testRunPtInRing4d() {
        CoordinateSequence cs = new PackedCoordinateSequenceFactory(0).create(new double[]{0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 5.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 4, 1);
        RayCrossingCounterTest.assertEquals((int)0, (int)RayCrossingCounter.locatePointInRing(new Coordinate(5.0, 2.0), cs));
    }
}

