/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.MinimumDiameter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class MinimumDiameterTest
extends TestCase {
    private PrecisionModel precisionModel = new PrecisionModel(1.0);
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run(MinimumDiameterTest.class);
    }

    public MinimumDiameterTest(String name) {
        super(name);
    }

    public void testMinimumDiameter1() throws Exception {
        this.doMinimumDiameterTest(true, "POINT (0 240)", new Coordinate(0.0, 240.0), new Coordinate(0.0, 240.0));
    }

    public void testMinimumDiameter2() throws Exception {
        this.doMinimumDiameterTest(true, "LINESTRING (0 240, 220 240)", new Coordinate(0.0, 240.0), new Coordinate(0.0, 240.0));
    }

    public void testMinimumDiameter3() throws Exception {
        this.doMinimumDiameterTest(true, "POLYGON ((0 240, 220 240, 220 0, 0 0, 0 240))", new Coordinate(220.0, 240.0), new Coordinate(0.0, 240.0));
    }

    public void testMinimumDiameter4() throws Exception {
        this.doMinimumDiameterTest(true, "POLYGON ((0 240, 220 240, 220 0, 0 0, 0 240))", new Coordinate(220.0, 240.0), new Coordinate(0.0, 240.0));
    }

    public void testMinimumDiameter5() throws Exception {
        this.doMinimumDiameterTest(true, "POLYGON ((0 240, 160 140, 220 0, 0 0, 0 240))", new Coordinate(185.86206896551724, 79.65517241379311), new Coordinate(0.0, 0.0));
    }

    public void testMinimumDiameter6() throws Exception {
        this.doMinimumDiameterTest(false, "LINESTRING ( 39 119, 162 197, 135 70, 95 35, 33 66, 111 82, 97 131, 48 160, -4 182, 57 195, 94 202, 90 174, 75 134, 47 114, 0 100, 59 81, 123 60, 136 43, 163 75, 145 114, 93 136, 92 159, 105 175 )", new Coordinate(64.46262341325811, 196.41184767277855), new Coordinate(95.0, 35.0));
    }

    private void doMinimumDiameterTest(boolean convex, String wkt, Coordinate c0, Coordinate c1) throws ParseException {
        Coordinate[] minimumDiameter = new MinimumDiameter(new WKTReader().read(wkt), convex).getDiameter().getCoordinates();
        double tolerance = 1.0E-10;
        MinimumDiameterTest.assertEquals((double)c0.x, (double)minimumDiameter[0].x, (double)tolerance);
        MinimumDiameterTest.assertEquals((double)c0.y, (double)minimumDiameter[0].y, (double)tolerance);
        MinimumDiameterTest.assertEquals((double)c1.x, (double)minimumDiameter[1].x, (double)tolerance);
        MinimumDiameterTest.assertEquals((double)c1.y, (double)minimumDiameter[1].y, (double)tolerance);
    }
}

