/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import test.jts.GeometryTestCase;

public abstract class AbstractPointInRingTest
extends GeometryTestCase {
    public static final String comb = "POLYGON ((0 0, 0 10, 4 5, 6 10, 7 5, 9 10, 10 5, 13 5, 15 10, 16 3, 17 10, 18 3, 25 10, 30 10, 30 0, 15 0, 14 5, 13 0, 9 0, 8 5, 6 0, 0 0))";
    public static final String repeatedPts = "POLYGON ((0 0, 0 10, 2 5, 2 5, 2 5, 2 5, 2 5, 3 10, 6 10, 8 5, 8 5, 8 5, 8 5, 10 10, 10 5, 10 5, 10 5, 10 5, 10 0, 0 0))";

    public AbstractPointInRingTest(String name) {
        super(name);
    }

    public void testBox() throws Exception {
        this.runPtInRing(0, new Coordinate(10.0, 10.0), "POLYGON ((0 0, 0 20, 20 20, 20 0, 0 0))");
    }

    public void testComplexRing() throws Exception {
        this.runPtInRing(0, new Coordinate(0.0, 0.0), "POLYGON ((-40 80, -40 -80, 20 0, 20 -100, 40 40, 80 -80, 100 80, 140 -20, 120 140, 40 180,     60 40, 0 120, -20 -20, -40 80))");
    }

    public void testComb() throws Exception {
        this.runPtInRing(1, new Coordinate(0.0, 0.0), comb);
        this.runPtInRing(1, new Coordinate(0.0, 1.0), comb);
        this.runPtInRing(1, new Coordinate(4.0, 5.0), comb);
        this.runPtInRing(1, new Coordinate(8.0, 5.0), comb);
        this.runPtInRing(1, new Coordinate(11.0, 5.0), comb);
        this.runPtInRing(1, new Coordinate(30.0, 5.0), comb);
        this.runPtInRing(1, new Coordinate(22.0, 7.0), comb);
        this.runPtInRing(0, new Coordinate(1.0, 5.0), comb);
        this.runPtInRing(0, new Coordinate(5.0, 5.0), comb);
        this.runPtInRing(0, new Coordinate(1.0, 7.0), comb);
        this.runPtInRing(2, new Coordinate(12.0, 10.0), comb);
        this.runPtInRing(2, new Coordinate(16.0, 5.0), comb);
        this.runPtInRing(2, new Coordinate(35.0, 5.0), comb);
    }

    public void testRepeatedPts() throws Exception {
        this.runPtInRing(1, new Coordinate(0.0, 0.0), repeatedPts);
        this.runPtInRing(1, new Coordinate(0.0, 1.0), repeatedPts);
        this.runPtInRing(1, new Coordinate(2.0, 5.0), repeatedPts);
        this.runPtInRing(1, new Coordinate(8.0, 5.0), repeatedPts);
        this.runPtInRing(1, new Coordinate(10.0, 5.0), repeatedPts);
        this.runPtInRing(0, new Coordinate(1.0, 5.0), repeatedPts);
        this.runPtInRing(0, new Coordinate(3.0, 5.0), repeatedPts);
    }

    public void testRobustStressTriangles() throws Exception {
        this.runPtInRing(2, new Coordinate(25.374625374625374, 128.35564435564436), "POLYGON ((0.0 0.0, 0.0 172.0, 100.0 0.0, 0.0 0.0))");
        this.runPtInRing(0, new Coordinate(97.96039603960396, 782.0), "POLYGON ((642.0 815.0, 69.0 764.0, 394.0 966.0, 642.0 815.0))");
    }

    public void testRobustTriangle() throws Exception {
        this.runPtInRing(2, new Coordinate(3.166572116932842, 48.5390194687463), "POLYGON ((2.152214146946829 50.470470727186765, 18.381941666723034 19.567250592139274, 2.390837642830135 49.228045261718165, 2.152214146946829 50.470470727186765))");
    }

    protected abstract void runPtInRing(int var1, Coordinate var2, String var3) throws Exception;
}

