/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.infomode;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.date.DateUtils;

class InfoPanel
extends JPanel {
    private Collection<IGpxTrack> tracks;
    private IGpxTrack trk;
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();
    private JLabel label3 = new JLabel();
    private JLabel label4 = new JLabel();
    private JLabel label5 = new JLabel();
    private JLabel label6 = new JLabel();
    private JButton but1 = new JButton(I18n.tr((String)"Delete this", (Object[])new Object[0]));
    private JButton but2 = new JButton(I18n.tr((String)"Delete this&older", (Object[])new Object[0]));

    InfoPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.label1, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label2, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label3, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label4, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label5, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label6, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.but1, GBC.std().insets(10, 5, 0, 0));
        this.add((Component)this.but2, GBC.eop().insets(10, 5, 0, 0));
        this.label6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String s = InfoPanel.this.label6.getText();
                OpenBrowser.displayUrl((String)s.substring(9, s.length() - 11));
            }
        });
        this.but1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoPanel.this.tracks != null) {
                    InfoPanel.this.tracks.remove(InfoPanel.this.trk);
                }
                MainApplication.getMap().mapView.repaint();
            }
        });
        this.but2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoPanel.this.tracks == null) {
                    return;
                }
                HashSet<IGpxTrack> toRemove = new HashSet<IGpxTrack>();
                double tm = -1.0;
                for (IGpxTrackSegment seg : InfoPanel.this.trk.getSegments()) {
                    for (WayPoint S : seg.getWayPoints()) {
                        if (!(S.getTime() > tm)) continue;
                        tm = S.getTime();
                    }
                }
                for (IGpxTrack track : InfoPanel.this.tracks) {
                    boolean f = true;
                    block3: for (IGpxTrackSegment seg : track.getSegments()) {
                        for (WayPoint S : seg.getWayPoints()) {
                            if (!(S.getTime() > tm)) continue;
                            f = false;
                            break block3;
                        }
                    }
                    if (!f) continue;
                    toRemove.add(track);
                }
                InfoPanel.this.tracks.removeAll(toRemove);
                MainApplication.getMap().mapView.repaint();
            }
        });
    }

    void setData(WayPoint wp, IGpxTrack trk, double vel, Collection<IGpxTrack> tracks) {
        this.tracks = tracks;
        this.trk = trk;
        if (!wp.hasDate()) {
            this.label1.setText(I18n.tr((String)"No timestamp", (Object[])new Object[0]));
            this.but2.setVisible(false);
        } else {
            this.label1.setText(DateUtils.getDateTimeFormat((int)2, (int)2).format(Date.from(wp.getInstant())));
            this.but2.setVisible(true);
        }
        if (vel > 0.0) {
            SystemOfMeasurement som = SystemOfMeasurement.getSystemOfMeasurement();
            this.label2.setText(String.format("%.1f " + som.speedName, vel * som.speedValue));
        } else {
            this.label2.setText(null);
        }
        String s = (String)trk.getAttributes().get("name");
        if (s != null) {
            this.label3.setText(I18n.tr((String)"Track name: ", (Object[])new Object[0]) + s);
        } else {
            this.label3.setText(null);
        }
        s = (String)trk.getAttributes().get("desc");
        this.label4.setText(s);
        s = (String)wp.attr.get("ele");
        String s1 = "";
        if (s != null) {
            try {
                s1 = String.format("H=%3.1f   ", Double.parseDouble(s));
            }
            catch (NumberFormatException e) {
                Logging.warn((Throwable)e);
            }
        }
        s1 = s1 + "L=" + (int)trk.length();
        this.label5.setText(s1);
        if (trk.getAttributes().containsKey("url")) {
            this.label6.setText(String.format("<html><u>%s</u></html>", trk.getAttributes().get("url").toString()));
        } else {
            this.label6.setText(null);
        }
    }
}

