/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.editgpx.EditGpxMode;
import org.openstreetmap.josm.plugins.editgpx.GPXLayerImportAction;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxData;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrack;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrackSegment;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxWayPoint;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditGpxLayer
extends Layer {
    private static final Icon icon = new ImageProvider("editgpx_layer").get();
    public final EditGpxData data;
    private final GPXLayerImportAction layerImport;

    public EditGpxLayer(EditGpxData gpxData) {
        super(I18n.tr((String)"EditGpx", (Object[])new Object[0]));
        this.data = gpxData;
        this.layerImport = new GPXLayerImportAction(this.data);
    }

    public void initializeImport() {
        if (this.data.isEmpty()) {
            this.layerImport.activateImport();
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, this.layerImport, new ConvertToGpxLayerAction(), new ConvertToAnonTimeGpxLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer for editing GPX tracks", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        g.setColor(Color.yellow);
        Object object = this.layerImport.importing;
        synchronized (object) {
            Projection projection = ProjectionRegistry.getProjection();
            for (EditGpxTrack track : this.data.getTracks()) {
                for (EditGpxTrackSegment segment : track.getSegments()) {
                    for (EditGpxWayPoint wayPoint : segment.getWayPoints()) {
                        if (wayPoint.isDeleted()) continue;
                        Point pnt = mv.getPoint(wayPoint.getCoor().getEastNorth((Projecting)projection));
                        g.drawOval(pnt.x - 2, pnt.y - 2, 4, 4);
                    }
                }
            }
        }
    }

    public void reset() {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private GpxData toGpxData(boolean anonTime) {
        return this.data.createGpxData(anonTime);
    }

    public class ConvertToAnonTimeGpxLayerAction
    extends AbstractAction {
        public ConvertToAnonTimeGpxLayerAction() {
            super(I18n.tr((String)"Convert to GPX layer with anonymised time", (Object[])new Object[0]), ImageProvider.get((String)"converttogpx"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainApplication.getMap().mapMode instanceof EditGpxMode && !MainApplication.getMap().selectSelectTool(false)) {
                MainApplication.getMap().selectZoomTool(false);
            }
            MainApplication.getLayerManager().addLayer((Layer)new GpxLayer(EditGpxLayer.this.toGpxData(true), I18n.tr((String)"Converted from: {0}", (Object[])new Object[]{EditGpxLayer.this.getName()})));
            MainApplication.getLayerManager().removeLayer((Layer)EditGpxLayer.this);
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr((String)"Convert to GPX layer", (Object[])new Object[0]), ImageProvider.get((String)"converttogpx"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainApplication.getMap().mapMode instanceof EditGpxMode && !MainApplication.getMap().selectSelectTool(false)) {
                MainApplication.getMap().selectZoomTool(false);
            }
            MainApplication.getLayerManager().addLayer((Layer)new GpxLayer(EditGpxLayer.this.toGpxData(false), I18n.tr((String)"Converted from: {0}", (Object[])new Object[]{EditGpxLayer.this.getName()})));
            MainApplication.getLayerManager().removeLayer((Layer)EditGpxLayer.this);
        }
    }
}

