/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CadastreInterface;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.DuplicateLayerException;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.EastNorthBound;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.SVGParser;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSException;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.WMSLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DownloadSVGTask
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private CadastreInterface wmsInterface;
    private String svg;
    private EastNorthBound viewBox;
    private static String errorMessage;

    public DownloadSVGTask(WMSLayer wmsLayer) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.getName()}));
        this.wmsLayer = wmsLayer;
        this.wmsInterface = wmsLayer.grabber.getWmsInterface();
    }

    public void realRun() throws IOException, OsmTransferException {
        this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Contacting WMS Server...", (Object[])new Object[0]));
        errorMessage = null;
        try {
            if (this.wmsInterface.retrieveInterface(this.wmsLayer)) {
                this.svg = this.grabBoundary(this.wmsLayer.getCommuneBBox());
                if (this.svg == null) {
                    return;
                }
                this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Extract SVG ViewBox...", (Object[])new Object[0]));
                this.getViewBox(this.svg);
                if (this.viewBox == null) {
                    return;
                }
                this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Extract best fitting boundary...", (Object[])new Object[0]));
                this.createWay(this.svg);
            }
        }
        catch (DuplicateLayerException e) {
            Logging.warn((String)"removed a duplicated layer");
        }
        catch (WMSException e) {
            errorMessage = e.getMessage();
            this.wmsLayer.grabber.getWmsInterface().resetCookie();
        }
    }

    protected void cancel() {
        this.wmsLayer.grabber.getWmsInterface().cancel();
    }

    protected void finish() {
    }

    private boolean getViewBox(String svg) {
        double[] box = new SVGParser().getViewBox(svg);
        if (box != null) {
            this.viewBox = new EastNorthBound(new EastNorth(box[0], box[1]), new EastNorth(box[0] + box[2], box[1] + box[3]));
            return true;
        }
        Logging.warn((String)"Unable to parse SVG data (viewBox)");
        return false;
    }

    private void createWay(String svg) {
        String[] SVGpaths = new SVGParser().getClosedPaths(svg);
        ArrayList<Double> fitViewBox = new ArrayList<Double>();
        ArrayList<ArrayList<EastNorth>> eastNorths = new ArrayList<ArrayList<EastNorth>>();
        for (int i = 0; i < SVGpaths.length; ++i) {
            ArrayList<EastNorth> eastNorth = new ArrayList<EastNorth>();
            fitViewBox.add(this.createNodes(SVGpaths[i], eastNorth));
            eastNorths.add(eastNorth);
        }
        Double min = (Double)Collections.min(fitViewBox);
        int bestPath = fitViewBox.indexOf(min);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (EastNorth eastNorth : (ArrayList)eastNorths.get(bestPath)) {
            nodeList.add(new Node(ProjectionRegistry.getProjection().eastNorth2latlon(eastNorth)));
        }
        Way wayToAdd = new Way();
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        for (Node node : nodeList) {
            cmds.add(new AddCommand(ds, (OsmPrimitive)node));
            wayToAdd.addNode(node);
        }
        wayToAdd.addNode(wayToAdd.getNode(0));
        cmds.add(new AddCommand(ds, (OsmPrimitive)wayToAdd));
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Create boundary", (Object[])new Object[0]), cmds));
        MainApplication.getMap().repaint();
    }

    private double createNodes(String SVGpath, ArrayList<EastNorth> eastNorth) {
        String[] coor = SVGpath.split("[MlZ ]");
        double dx = Double.parseDouble(coor[1]);
        double dy = Double.parseDouble(coor[2]);
        double minY = Double.MAX_VALUE;
        double minX = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxX = Double.MIN_VALUE;
        for (int i = 3; i < coor.length; i += 2) {
            double east = dx += Double.parseDouble(coor[i]);
            double north = dy += Double.parseDouble(coor[i + 1]);
            eastNorth.add(new EastNorth(east, north));
            minX = minX > east ? east : minX;
            minY = minY > north ? north : minY;
            maxX = maxX < east ? east : maxX;
            maxY = maxY < north ? north : maxY;
        }
        double pivot = this.viewBox.min.getY() + (this.viewBox.max.getY() - this.viewBox.min.getY()) / 2.0;
        for (int i = 0; i < eastNorth.size(); ++i) {
            EastNorth en = eastNorth.get(i);
            eastNorth.set(i, new EastNorth(en.east(), 2.0 * pivot - en.north()));
        }
        return Math.abs(minX - this.viewBox.min.getX()) + Math.abs(maxX - this.viewBox.max.getX()) + Math.abs(minY - this.viewBox.min.getY()) + Math.abs(maxY - this.viewBox.max.getY());
    }

    private String grabBoundary(EastNorthBound bbox) throws IOException, OsmTransferException {
        try {
            return this.grabSVG(DownloadSVGTask.getURLsvg(bbox));
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.", (Object[])new Object[0])).initCause(e);
        }
    }

    private static URL getURLsvg(EastNorthBound bbox) throws MalformedURLException {
        String str = "https://www.cadastre.gouv.fr/scpc/wms?version=1.1&request=GetMap";
        str = str + "&layers=";
        str = str + "CDIF:COMMUNE";
        str = str + "&format=image/svg";
        str = str + "&bbox=" + bbox.min.east() + ",";
        str = str + bbox.min.north() + ",";
        str = str + bbox.max.east() + ",";
        str = str + bbox.max.north();
        str = str + "&width=" + CadastrePlugin.imageWidth + "&height=" + CadastrePlugin.imageHeight;
        str = str + "&styles=";
        str = str + "COMMUNE_90";
        Logging.info((String)("URL=" + str));
        return new URL(str.replace(" ", "%20"));
    }

    private String grabSVG(URL url) throws IOException, OsmTransferException {
        File file = new File(CadastrePlugin.cacheDir + "boundary.svg");
        String svg = "";
        try (InputStream is = this.wmsInterface.getContent(url);){
            if (file.exists()) {
                file.delete();
            }
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));
                 InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while (null != (line = br.readLine())) {
                    line = line + "\n";
                    bos.write(line.getBytes(StandardCharsets.UTF_8));
                    svg = svg + line;
                }
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        return svg;
    }

    public static void download(WMSLayer wmsLayer) {
        if (!CadastrePlugin.autoSourcing) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please, enable auto-sourcing and check cadastre millesime.", (Object[])new Object[0]));
            return;
        }
        MainApplication.worker.execute((Runnable)((Object)new DownloadSVGTask(wmsLayer)));
        if (errorMessage != null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), errorMessage);
        }
    }
}

