/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.HgtReader;
import org.openstreetmap.josm.plugins.elevation.gpx.GeoidCorrectionKind;
import org.openstreetmap.josm.tools.Logging;

public final class ElevationHelper {
    public static final double NO_ELEVATION = Double.NaN;
    public static final String HEIGHT_ATTRIBUTE = "ele";
    private static GeoidCorrectionKind geoidKind = GeoidCorrectionKind.None;

    private ElevationHelper() {
    }

    public static GeoidCorrectionKind getGeoidKind() {
        return geoidKind;
    }

    public static void setGeoidKind(GeoidCorrectionKind geoidKind) {
        ElevationHelper.geoidKind = geoidKind;
    }

    public static boolean isValidElevation(double ele) {
        return !Double.isNaN(ele);
    }

    public static double getElevation(WayPoint wpt) {
        if (wpt == null) {
            return Double.NaN;
        }
        double eleInt = ElevationHelper.getSrtmElevation((ILatLon)wpt.getCoor());
        if (ElevationHelper.isValidElevation(eleInt)) {
            return eleInt;
        }
        Object height = wpt.get(HEIGHT_ATTRIBUTE);
        if (height instanceof String) {
            try {
                return Double.parseDouble((String)height);
            }
            catch (NumberFormatException e) {
                Logging.error((String)String.format("Cannot parse double from '%s': %s", height, e.getMessage()));
            }
        } else if (height instanceof Double && ElevationHelper.isValidElevation(eleInt = ((Double)height).doubleValue())) {
            return eleInt;
        }
        return Double.NaN;
    }

    private static double getElevation(LatLon ll) {
        return ElevationHelper.getSrtmElevation((ILatLon)ll);
    }

    public static double computeSlope(LatLon w1, LatLon w2) {
        if (w1.equals((Object)w2)) {
            return 0.0;
        }
        double distInMeter = w1.greatCircleDistance((ILatLon)w2) / 100.0;
        int ele1 = (int)ElevationHelper.getElevation(w1);
        int ele2 = (int)ElevationHelper.getElevation(w2);
        int dH = ele2 - ele1;
        return (double)dH / distInMeter;
    }

    public static String getElevationText(int elevation) {
        return SystemOfMeasurement.getSystemOfMeasurement().getDistText((double)elevation);
    }

    public static String getElevationText(double elevation) {
        return SystemOfMeasurement.getSystemOfMeasurement().getDistText((double)((int)Math.round(elevation)));
    }

    public static String getElevationText(WayPoint wpt) {
        if (wpt == null) {
            return "-";
        }
        return ElevationHelper.getElevationText(ElevationHelper.getElevation(wpt));
    }

    public static String getTimeText(WayPoint wpt) {
        if (wpt == null) {
            return null;
        }
        int hour = ElevationHelper.getHourOfWayPoint(wpt);
        int min = ElevationHelper.getMinuteOfWayPoint(wpt);
        return String.format("%02d:%02d", hour, min);
    }

    public static double getSrtmElevation(ILatLon ll) {
        double eleHgt;
        if (ll != null && ElevationHelper.isValidElevation(eleHgt = HgtReader.getElevationFromHgt(ll))) {
            return eleHgt;
        }
        return Double.NaN;
    }

    public static Optional<Bounds> getBounds(ILatLon location) {
        if (location != null) {
            return HgtReader.getBounds(location);
        }
        return Optional.empty();
    }

    public static boolean hasSrtmData(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        LatLon tl = bounds.getMin();
        LatLon br = bounds.getMax();
        return ElevationHelper.isValidElevation(ElevationHelper.getSrtmElevation((ILatLon)tl)) && ElevationHelper.isValidElevation(ElevationHelper.getSrtmElevation((ILatLon)br));
    }

    public static byte getGeoidCorrection(WayPoint wpt) {
        return 0;
    }

    public static List<WayPoint> downsampleWayPoints(List<WayPoint> origList, int targetSize) {
        if (origList == null) {
            return null;
        }
        if (targetSize <= 0) {
            throw new IllegalArgumentException("targetSize must be greater than zero");
        }
        int origSize = origList.size();
        if (origSize <= targetSize) {
            return origList;
        }
        int delta = (int)Math.max(Math.ceil(origSize / targetSize), 2.0);
        ArrayList<WayPoint> res = new ArrayList<WayPoint>(targetSize);
        for (int i = 0; i < origSize; i += delta) {
            res.add(origList.get(i));
        }
        return res;
    }

    public static int getHourOfWayPoint(WayPoint wpt) {
        if (wpt == null) {
            return -1;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(wpt.getTimeInMillis());
        return calendar.get(11);
    }

    public static int getMinuteOfWayPoint(WayPoint wpt) {
        if (wpt == null) {
            return -1;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(wpt.getTimeInMillis());
        return calendar.get(12);
    }
}

