/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import org.openstreetmap.josm.plugins.pdfimport.GuiFieldString;

public class GuiFieldDouble
extends GuiFieldString {
    private double value;
    public CheckDouble checker = new CheckDouble();

    public GuiFieldDouble() {
        this.addFocusListener(this.checker);
        this.setValue(0.0);
    }

    private GuiFieldDouble(String text) {
        super(text);
        this.addFocusListener(this.checker);
    }

    public GuiFieldDouble(double v) {
        this.addFocusListener(this.checker);
        this.setValue(v);
    }

    public void setValue(double v) {
        super.setText(Double.toString(v));
        this.checker.check(this);
    }

    public double getValue() throws NumberFormatException {
        if (!this.dataValid) {
            throw new NumberFormatException();
        }
        return this.value;
    }

    public class CheckDouble
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.check((GuiFieldDouble)event.getSource());
        }

        public void check(GuiFieldDouble field) {
            try {
                GuiFieldDouble.this.value = Double.parseDouble(field.getText());
                GuiFieldDouble.this.dataValid = true;
                field.setBorder(GuiFieldDouble.this.defaultBorder);
            }
            catch (NumberFormatException e) {
                field.setBorder(BorderFactory.createLineBorder(Color.red));
                GuiFieldDouble.this.value = Double.NaN;
                GuiFieldDouble.this.dataValid = false;
            }
        }
    }
}

