/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import reverter.MultiOsmReader;

public class OsmServerMultiObjectReader
extends OsmServerReader {
    private final MultiOsmReader rdr = new MultiOsmReader();
    protected static final int MAX_QUERY_IDS = 2000;
    protected static final int MAX_QUERY_LENGTH = 8000;

    public void readObject(PrimitiveId id, int version, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.readObject(id.getUniqueId(), version, id.getType(), progressMonitor);
    }

    public void readObject(long id, int version, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getAPIName());
        sb.append("/");
        sb.append(id);
        sb.append("/");
        sb.append(version);
        progressMonitor.beginTask("", 1);
        try (InputStream in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));){
            this.rdr.addData(in);
        }
        catch (IOException | IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static List<String> makeQueryStrings(OsmPrimitiveType type, Map<Long, Integer> list) {
        int expectedSize = (int)(list.entrySet().stream().mapToLong(entry -> Math.round(Math.log10(((Long)entry.getKey()).longValue())) + 1L + Math.round(Math.log10(((Integer)entry.getValue()).intValue())) + 1L + 2L).sum() / 8000L);
        ArrayList<String> result = new ArrayList<String>(expectedSize + 1);
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (Map.Entry<Long, Integer> entry2 : list.entrySet()) {
            if (cnt == 0) {
                sb.append(type.getAPIName());
                sb.append("s?");
                sb.append(type.getAPIName());
                sb.append("s=");
            } else {
                sb.append(",");
            }
            sb.append(entry2.getKey());
            sb.append("v");
            sb.append(entry2.getValue());
            if (++cnt < 2000 && sb.length() <= 8000) continue;
            result.add(sb.toString());
            sb.setLength(0);
            cnt = 0;
        }
        if (cnt > 0) {
            result.add(sb.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMultiObjects(OsmPrimitiveType type, Map<Long, Integer> list, ProgressMonitor progressMonitor) throws OsmTransferException {
        for (String query : OsmServerMultiObjectReader.makeQueryStrings(type, list)) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            this.rdr.callback = id -> {
                if (id.getType() == type && list.remove(id.getUniqueId()) != null) {
                    progressMonitor.worked(1);
                }
            };
            try {
                InputStream in = this.getInputStream(query, NullProgressMonitor.INSTANCE);
                Throwable throwable = null;
                try {
                    this.rdr.addData(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    OsmServerMultiObjectReader.$closeResource(throwable, in);
                }
            }
            catch (IOException | IllegalDataException e) {
                Logging.warn((Throwable)e);
                throw new OsmTransferException(e);
            }
            catch (OsmApiException e) {
                Logging.warn((Throwable)e);
                if (e.getResponseCode() == 403 || e.getResponseCode() == 404) continue;
                throw e;
            }
            finally {
                this.rdr.callback = null;
            }
        }
    }

    public void readMultiObjectsOrNextOlder(OsmPrimitiveType type, Map<Long, Integer> list, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.readMultiObjects(type, list, progressMonitor);
        for (Map.Entry<Long, Integer> entry : list.entrySet()) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            this.readObjectVersion(type, entry.getKey(), entry.getValue(), progressMonitor);
        }
    }

    private void readObjectVersion(OsmPrimitiveType type, long id, int version, ProgressMonitor progressMonitor) throws OsmTransferException {
        boolean readOK = false;
        while (!readOK && version >= 1) {
            try {
                this.readObject(id, version, type, progressMonitor.createSubTaskMonitor(1, true));
                readOK = true;
            }
            catch (OsmApiException e) {
                if (e.getResponseCode() != 403) {
                    throw e;
                }
                String message = "Version " + version + " of " + id + " is unauthorized";
                Logging.info((String)(version <= 1 ? message : message + ", requesting previous one"));
                --version;
            }
        }
        if (!readOK) {
            Logging.warn((String)"Cannot retrieve any previous version of {1} {2}", (Object[])new Object[]{type, id});
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        progressMonitor.subTask(I18n.tr((String)"Preparing history data...", (Object[])new Object[0]));
        try {
            this.rdr.processData();
            DataSet dataSet = this.rdr.getDataSet();
            return dataSet;
        }
        catch (Exception e) {
            throw new OsmTransferException((Throwable)e);
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

