/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.SelectByInternalPointAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectBoundaryAction
extends JosmAction {
    private Way lastUsedStartingWay;
    private boolean lastUsedLeft;

    public SelectBoundaryAction() {
        super(I18n.tr((String)"Area boundary [testing]", (Object[])new Object[0]), "selboundary", I18n.tr((String)"Select relation or all ways that forms area boundary", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selboundary", (String)I18n.tr((String)"Selection: {0}", (Object[])new Object[]{I18n.tr((String)"Area boundary [testing]", (Object[])new Object[0])}), (int)47, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectAreaBoundary"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        if (ds != null) {
            Collection selectedWays = ds.getSelectedWays();
            Collection selectedNodes = ds.getSelectedNodes();
            HashSet<Way> newWays = new HashSet<Way>();
            Way w = null;
            if (selectedWays.isEmpty()) {
                if (selectedNodes.size() == 1) {
                    for (OsmPrimitive p : ((Node)selectedNodes.iterator().next()).getReferrers()) {
                        if (!(p instanceof Way) || !p.isSelectable()) continue;
                        w = (Way)p;
                        break;
                    }
                } else if (MainApplication.isDisplayingMapView()) {
                    MapView mapView = MainApplication.getMap().mapView;
                    Point p = mapView.getMousePosition();
                    if (p != null) {
                        SelectByInternalPointAction.performSelection((EastNorth)mapView.getEastNorth(p.x, p.y), (boolean)false, (boolean)false);
                    }
                    return;
                }
            } else if (selectedWays.size() == 1) {
                w = (Way)selectedWays.iterator().next();
            } else if (selectedWays.contains(this.lastUsedStartingWay)) {
                w = this.lastUsedStartingWay;
                boolean bl = this.lastUsedLeft = !this.lastUsedLeft;
            }
            if (w == null) {
                return;
            }
            if (!w.isSelectable()) {
                return;
            }
            if (w.isClosed()) {
                return;
            }
            if (w.getNodesCount() < 2) {
                return;
            }
            newWays.add(w);
            this.lastUsedStartingWay = w;
            if (!NodeWayUtils.addAreaBoundary(w, newWays, this.lastUsedLeft)) {
                NodeWayUtils.addAreaBoundary(w, newWays, !this.lastUsedLeft);
            }
            if (!newWays.isEmpty()) {
                ds.setSelected(newWays);
            } else {
                new Notification(I18n.tr((String)"Nothing found. Please select way that is a part of some polygon formed by connected ways", (Object[])new Object[0])).setIcon(2).show();
            }
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveDataSet() != null);
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean hasSel;
        boolean bl = hasSel = selection != null && !selection.isEmpty();
        if (!hasSel) {
            this.lastUsedStartingWay = null;
        }
        this.setEnabled(hasSel);
    }
}

