/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoLotFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;

public class EdigeoFileQAL
extends EdigeoLotFile<QalBlock> {
    public EdigeoFileQAL(EdigeoFileTHF.Lot lot, String seId, Path path) throws IOException {
        super(lot, seId, path);
        this.register("QUP", Update.class);
        lot.qal = this;
    }

    public static class Update
    extends QalBlock {
        LocalDate observationDate;
        UpdateType updateType;
        Perennity perennity;
        LocalDate updateDate;
        double annualRatio;
        LocalDate endOfValidity;
        int nElements;
        final List<String> mcdRef = new ArrayList<String>();

        Update(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "ODA": {
                    this.observationDate = this.safeGetDate(r);
                    break;
                }
                case "UTY": {
                    this.updateType = UpdateType.of(this.safeGetInt(r));
                    break;
                }
                case "ULO": {
                    this.perennity = Perennity.of(this.safeGetInt(r));
                    break;
                }
                case "UDA": {
                    this.updateDate = this.safeGetDate(r);
                    break;
                }
                case "RAT": {
                    this.annualRatio = this.safeGetDouble(r);
                    break;
                }
                case "EDA": {
                    this.endOfValidity = this.safeGetDate(r);
                    break;
                }
                case "COC": {
                    this.nElements = this.safeGetInt(r);
                    break;
                }
                case "COP": {
                    this.safeGet(r, this.mcdRef);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        static enum UpdateType {
            NO_MODIFICATION(0),
            CREATION(1),
            REPLACEMENT(2),
            DELETION(3);

            final int code;

            private UpdateType(int code) {
                this.code = code;
            }

            public static UpdateType of(int code) {
                for (UpdateType s : UpdateType.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(code));
            }
        }

        static enum Perennity {
            TEMPORARY(1),
            DEFINITIVE(2);

            final int code;

            private Perennity(int code) {
                this.code = code;
            }

            public static Perennity of(int code) {
                for (Perennity s : Perennity.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(code));
            }
        }
    }

    public static class SpecificQuality
    extends QalBlock {
        SpecificQuality(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    public static class LogicalCoherence
    extends QalBlock {
        LogicalCoherence(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    public static class SemanticPrecision
    extends QalBlock {
        SemanticPrecision(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    public static class Exhaustivity
    extends QalBlock {
        Exhaustivity(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    public static class MetricPrecision
    extends QalBlock {
        MetricPrecision(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    public static class VerticalPrecision
    extends QalBlock {
        VerticalPrecision(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    public static class HorizontalPrecision
    extends QalBlock {
        HorizontalPrecision(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    public static class Genealogy
    extends QalBlock {
        Genealogy(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }

    static abstract class QalBlock
    extends EdigeoFileTHF.ChildBlock {
        QalBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }
}

