/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import livegps.LiveGPSPreferences;
import livegps.LiveGpsAcquirer;
import livegps.LiveGpsAcquirerNMEA;
import livegps.LiveGpsDialog;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LiveGpsPlugin
extends Plugin
implements LayerManager.LayerChangeListener {
    private boolean enabled = false;
    private LiveGpsAcquirer acquirer = null;
    private Thread acquirerThread = null;
    private LiveGpsAcquirerNMEA acquirerNMEA = null;
    private Thread acquirerNMEAThread = null;
    private JMenu lgpsmenu = null;
    private JCheckBoxMenuItem lgpscapture;
    private JCheckBoxMenuItem lgpsautocenter;
    private LiveGpsDialog lgpsdialog;
    List<PropertyChangeListener> listenerQueue = new ArrayList<PropertyChangeListener>();
    private GpxData data = new GpxData();
    private LiveGpsLayer lgpslayer = null;

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        Layer oldLayer = e.getRemovedLayer();
        if (oldLayer != this.lgpslayer) {
            return;
        }
        this.enableTracking(false);
        this.lgpscapture.setSelected(false);
        MainApplication.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        this.lgpslayer = null;
    }

    public LiveGpsPlugin(PluginInformation info) {
        super(info);
        MainMenu menu = MainApplication.getMenu();
        this.lgpsmenu = menu.gpsMenu;
        if (this.lgpsmenu.getItemCount() > 0) {
            this.lgpsmenu.addSeparator();
        }
        CaptureAction captureAction = new CaptureAction();
        this.lgpscapture = new JCheckBoxMenuItem((Action)((Object)captureAction));
        this.lgpsmenu.add(this.lgpscapture);
        this.lgpscapture.setAccelerator(captureAction.getShortcut().getKeyStroke());
        CenterAction centerAction = new CenterAction();
        MainMenu.add((JMenu)this.lgpsmenu, (JosmAction)centerAction);
        AutoCenterAction autoCenterAction = new AutoCenterAction();
        this.lgpsautocenter = new JCheckBoxMenuItem((Action)((Object)autoCenterAction));
        this.lgpsmenu.add(this.lgpsautocenter);
        this.lgpsautocenter.setAccelerator(autoCenterAction.getShortcut().getKeyStroke());
    }

    public void setAutoCenter(boolean autoCenter) {
        this.lgpsautocenter.setSelected(autoCenter);
        if (this.lgpslayer != null) {
            this.lgpslayer.setAutoCenter(autoCenter);
            if (autoCenter) {
                this.lgpslayer.center();
            }
        }
    }

    public boolean isAutoCenter() {
        return this.lgpsautocenter.isSelected();
    }

    public void enableTracking(boolean enable) {
        if (enable && !this.enabled) {
            if (this.lgpslayer == null) {
                this.lgpslayer = new LiveGpsLayer(this.data);
                MainApplication.getLayerManager().addLayer((Layer)this.lgpslayer);
                MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
                this.lgpslayer.setAutoCenter(this.isAutoCenter());
            }
            assert (this.acquirer == null);
            assert (this.acquirerThread == null);
            if (!Config.getPref().getBoolean("livegps.gpsd.disabled")) {
                this.acquirer = new LiveGpsAcquirer();
                this.acquirerThread = new Thread(this.acquirer);
                this.acquirer.addPropertyChangeListener(this.lgpslayer);
                this.acquirer.addPropertyChangeListener(this.lgpsdialog);
                for (PropertyChangeListener listener : this.listenerQueue) {
                    this.acquirer.addPropertyChangeListener(listener);
                }
                this.acquirerThread.start();
            }
            assert (this.acquirerNMEA == null);
            assert (this.acquirerNMEAThread == null);
            if (!Config.getPref().get("livegps.serial.port").isEmpty()) {
                this.acquirerNMEA = new LiveGpsAcquirerNMEA();
                this.acquirerNMEAThread = new Thread(this.acquirerNMEA);
                this.acquirerNMEA.addPropertyChangeListener(this.lgpslayer);
                this.acquirerNMEA.addPropertyChangeListener(this.lgpsdialog);
                for (PropertyChangeListener listener : this.listenerQueue) {
                    this.acquirerNMEA.addPropertyChangeListener(listener);
                }
                this.acquirerNMEAThread.start();
            }
            this.enabled = true;
        } else if (!enable && this.enabled) {
            assert (this.lgpslayer != null);
            assert (this.acquirer != null);
            assert (this.acquirerThread != null);
            if (this.acquirerThread != null) {
                this.acquirer.shutdown();
                this.acquirer = null;
                this.acquirerThread = null;
            }
            if (this.acquirerNMEAThread != null) {
                this.acquirerNMEA.shutdown();
                this.acquirerNMEA = null;
                this.acquirerNMEAThread = null;
            }
            this.enabled = false;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        assert (!this.listenerQueue.contains(listener));
        this.listenerQueue.add(listener);
        if (this.acquirer != null) {
            this.acquirer.addPropertyChangeListener(listener);
        }
        if (this.acquirerNMEA != null) {
            this.acquirerNMEA.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        assert (this.listenerQueue.contains(listener));
        this.listenerQueue.remove(listener);
        if (this.acquirer != null) {
            this.acquirer.removePropertyChangeListener(listener);
        }
        if (this.acquirerNMEA != null) {
            this.acquirerNMEA.removePropertyChangeListener(listener);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.lgpsdialog = new LiveGpsDialog(newFrame);
            newFrame.addToggleDialog((ToggleDialog)this.lgpsdialog);
        }
    }

    public JMenu getLgpsMenu() {
        return this.lgpsmenu;
    }

    public PreferenceSetting getPreferenceSetting() {
        return new LiveGPSPreferences();
    }

    public class AutoCenterAction
    extends JosmAction {
        public AutoCenterAction() {
            super(I18n.tr((String)"Auto-Center", (Object[])new Object[0]), "autocentermenu", I18n.tr((String)"Continuously center the LiveGPS layer to current position.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"menu:livegps:autocenter", (String)I18n.tr((String)"GPS: {0}", (Object[])new Object[]{I18n.tr((String)"Auto-Center", (Object[])new Object[0])}), (int)36, (int)5006), true);
        }

        public void actionPerformed(ActionEvent e) {
            if (LiveGpsPlugin.this.lgpslayer != null) {
                LiveGpsPlugin.this.setAutoCenter(LiveGpsPlugin.this.lgpsautocenter.isSelected());
            }
        }
    }

    public class CenterAction
    extends JosmAction {
        public CenterAction() {
            super(I18n.tr((String)"Center Once", (Object[])new Object[0]), "centermenu", I18n.tr((String)"Center the LiveGPS layer to current position.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"edit:centergps", (String)I18n.tr((String)"GPS: {0}", (Object[])new Object[]{I18n.tr((String)"Center Once", (Object[])new Object[0])}), (int)36, (int)5003), true);
        }

        public void actionPerformed(ActionEvent e) {
            if (LiveGpsPlugin.this.lgpslayer != null) {
                LiveGpsPlugin.this.lgpslayer.center();
            }
        }
    }

    public class CaptureAction
    extends JosmAction {
        public CaptureAction() {
            super(I18n.tr((String)"Capture GPS Track", (Object[])new Object[0]), "capturemenu", I18n.tr((String)"Connect to gpsd server and show current position in LiveGPS layer.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"menu:livegps:capture", (String)I18n.tr((String)"GPS: {0}", (Object[])new Object[]{I18n.tr((String)"Capture GPS Track", (Object[])new Object[0])}), (int)82, (int)5006), true);
        }

        public void actionPerformed(ActionEvent e) {
            LiveGpsPlugin.this.enableTracking(LiveGpsPlugin.this.lgpscapture.isSelected());
        }
    }
}

