/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.Subgraph;
import org.jgrapht.util.ArrayUnenforcedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedSubgraph<V, E>
extends Subgraph<V, E, DirectedGraph<V, E>>
implements DirectedGraph<V, E> {
    private static final long serialVersionUID = 3616445700507054133L;

    public DirectedSubgraph(DirectedGraph<V, E> directedGraph, Set<V> set, Set<E> set2) {
        super(directedGraph, set, set2);
    }

    @Override
    public int inDegreeOf(V v) {
        this.assertVertexExist(v);
        int n = 0;
        for (Object e : ((DirectedGraph)this.getBase()).incomingEdgesOf(v)) {
            if (!this.containsEdge(e)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Set<E> incomingEdgesOf(V v) {
        this.assertVertexExist(v);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet();
        Set set = ((DirectedGraph)this.getBase()).incomingEdgesOf(v);
        for (Object e : set) {
            if (!this.containsEdge(e)) continue;
            arrayUnenforcedSet.add(e);
        }
        return arrayUnenforcedSet;
    }

    @Override
    public int outDegreeOf(V v) {
        this.assertVertexExist(v);
        int n = 0;
        for (Object e : ((DirectedGraph)this.getBase()).outgoingEdgesOf(v)) {
            if (!this.containsEdge(e)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Set<E> outgoingEdgesOf(V v) {
        this.assertVertexExist(v);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet();
        Set set = ((DirectedGraph)this.getBase()).outgoingEdgesOf(v);
        for (Object e : set) {
            if (!this.containsEdge(e)) continue;
            arrayUnenforcedSet.add(e);
        }
        return arrayUnenforcedSet;
    }
}

