/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor.action;

import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.plugins.surveyor.GpsActionEvent;
import org.openstreetmap.josm.plugins.surveyor.SurveyorAction;

public class TaggingPresetAction
implements SurveyorAction {
    private String presetName;
    private TaggingPreset preset;

    @Override
    public void actionPerformed(GpsActionEvent event) {
        if (this.preset == null) {
            return;
        }
        LatLon coordinates = event.getCoordinates();
        System.out.println(this.getClass().getSimpleName() + " KOORD: " + coordinates.lat() + ", " + coordinates.lon() + ", preset=" + this.presetName);
        this.preset.actionPerformed(null);
    }

    @Override
    public void setParameters(List<String> parameters) {
        if (parameters.size() == 0) {
            throw new IllegalArgumentException("No annotation preset name given!");
        }
        this.presetName = parameters.get(0);
        this.preset = this.getAnnotationPreset(this.presetName);
        if (this.preset == null) {
            System.err.println("No valid preset '" + parameters.get(0) + "' found - disable action!");
            return;
        }
    }

    protected TaggingPreset getAnnotationPreset(String name) {
        for (TaggingPreset preset : TaggingPresets.getTaggingPresets()) {
            if (!name.equals(preset.getValue("Name"))) continue;
            return preset;
        }
        return null;
    }
}

