/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.TextPosition;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFStreamEngine {
    private static final Log LOG = LogFactory.getLog(PDFStreamEngine.class);
    private final Set<String> unsupportedOperators = new HashSet<String>();
    private PDGraphicsState graphicsState = null;
    private Matrix textMatrix = null;
    private Matrix textLineMatrix = null;
    private Stack<PDGraphicsState> graphicsStack = new Stack();
    private Map<String, OperatorProcessor> operators = new HashMap<String, OperatorProcessor>();
    private Stack<PDResources> streamResourcesStack = new Stack();
    private PDPage page;
    private int validCharCnt;
    private int totalCharCnt;
    private boolean forceParsing = false;

    public PDFStreamEngine() {
        this.validCharCnt = 0;
        this.totalCharCnt = 0;
    }

    public PDFStreamEngine(Properties properties) throws IOException {
        if (properties == null) {
            throw new NullPointerException("properties cannot be null");
        }
        Enumeration<?> names = properties.propertyNames();
        for (Object name : Collections.list(names)) {
            String operator = name.toString();
            String processorClassName = properties.getProperty(operator);
            if ("".equals(processorClassName)) {
                this.unsupportedOperators.add(operator);
                continue;
            }
            try {
                Class<?> klass = Class.forName(processorClassName);
                OperatorProcessor processor = (OperatorProcessor)klass.newInstance();
                this.registerOperatorProcessor(operator, processor);
            }
            catch (Exception e) {
                throw new WrappedIOException("OperatorProcessor class " + processorClassName + " could not be instantiated", e);
            }
        }
        this.validCharCnt = 0;
        this.totalCharCnt = 0;
    }

    public boolean isForceParsing() {
        return this.forceParsing;
    }

    public void setForceParsing(boolean forceParsingValue) {
        this.forceParsing = forceParsingValue;
    }

    public void registerOperatorProcessor(String operator, OperatorProcessor op) {
        op.setContext(this);
        this.operators.put(operator, op);
    }

    public void resetEngine() {
        this.validCharCnt = 0;
        this.totalCharCnt = 0;
    }

    public void processStream(PDPage aPage, PDResources resources, COSStream cosStream) throws IOException {
        this.graphicsState = new PDGraphicsState(aPage.findCropBox());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.graphicsStack.clear();
        this.streamResourcesStack.clear();
        this.processSubStream(aPage, resources, cosStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSubStream(PDPage aPage, PDResources resources, COSStream cosStream) throws IOException {
        this.page = aPage;
        if (resources != null) {
            this.streamResourcesStack.push(resources);
            try {
                this.processSubStream(cosStream);
            }
            finally {
                this.streamResourcesStack.pop().clear();
            }
        } else {
            this.processSubStream(cosStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSubStream(COSStream cosStream) throws IOException {
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        PDFStreamParser parser = new PDFStreamParser(cosStream, this.forceParsing);
        try {
            Iterator<Object> iter = parser.getTokenIterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("processing substream token: " + next);
                }
                if (next instanceof COSObject) {
                    arguments.add(((COSObject)next).getObject());
                    continue;
                }
                if (next instanceof PDFOperator) {
                    this.processOperator((PDFOperator)next, arguments);
                    arguments = new ArrayList();
                    continue;
                }
                arguments.add((COSBase)next);
            }
        }
        finally {
            parser.close();
        }
    }

    protected void processTextPosition(TextPosition text) {
    }

    protected String inspectFontEncoding(String str) {
        return str;
    }

    public void processEncodedText(byte[] string) throws IOException {
        float fontSizeText = this.graphicsState.getTextState().getFontSize();
        float horizontalScalingText = this.graphicsState.getTextState().getHorizontalScalingPercent() / 100.0f;
        float riseText = this.graphicsState.getTextState().getRise();
        float wordSpacingText = this.graphicsState.getTextState().getWordSpacing();
        float characterSpacingText = this.graphicsState.getTextState().getCharacterSpacing();
        PDFont font = this.graphicsState.getTextState().getFont();
        if (font == null) {
            LOG.warn("No current font, will use default");
            font = PDFontFactory.createDefaultFont();
        }
        float fontMatrixXScaling = 0.001f;
        float fontMatrixYScaling = 0.001f;
        float glyphSpaceToTextSpaceFactor = 0.001f;
        if (font instanceof PDType3Font) {
            PDMatrix fontMatrix = font.getFontMatrix();
            fontMatrixXScaling = fontMatrix.getValue(0, 0);
            fontMatrixYScaling = fontMatrix.getValue(1, 1);
            glyphSpaceToTextSpaceFactor = fontMatrix.getValue(0, 0);
        }
        float spaceWidthText = 0.0f;
        try {
            spaceWidthText = font.getSpaceWidth() * glyphSpaceToTextSpaceFactor;
        }
        catch (Throwable exception) {
            LOG.warn(exception, exception);
        }
        if (spaceWidthText == 0.0f) {
            spaceWidthText = font.getAverageFontWidth() * glyphSpaceToTextSpaceFactor;
            spaceWidthText *= 0.8f;
        }
        if (spaceWidthText == 0.0f) {
            spaceWidthText = 1.0f;
        }
        float maxVerticalDisplacementText = 0.0f;
        Matrix textStateParameters = new Matrix();
        textStateParameters.setValue(0, 0, fontSizeText * horizontalScalingText);
        textStateParameters.setValue(1, 1, fontSizeText);
        textStateParameters.setValue(2, 1, riseText);
        int pageRotation = this.page.findRotation();
        float pageHeight = this.page.findCropBox().getHeight();
        float pageWidth = this.page.findCropBox().getWidth();
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        Matrix textXctm = new Matrix();
        Matrix textMatrixEnd = new Matrix();
        Matrix td = new Matrix();
        Matrix tempMatrix = new Matrix();
        int codeLength = 1;
        for (int i = 0; i < string.length; i += codeLength) {
            codeLength = 1;
            String c = font.encode(string, i, codeLength);
            int[] codePoints = null;
            if (c == null && i + 1 < string.length) {
                c = font.encode(string, i, ++codeLength);
                codePoints = new int[]{font.getCodeFromArray(string, i, codeLength)};
            }
            float spaceWidthDisp = spaceWidthText * fontSizeText * horizontalScalingText * this.textMatrix.getXScale() * ctm.getXScale();
            float characterHorizontalDisplacementText = font.getFontWidth(string, i, codeLength);
            float characterVerticalDisplacementText = font.getFontHeight(string, i, codeLength);
            characterHorizontalDisplacementText *= fontMatrixXScaling;
            maxVerticalDisplacementText = Math.max(maxVerticalDisplacementText, characterVerticalDisplacementText *= fontMatrixYScaling);
            float spacingText = 0.0f;
            if (string[i] == 32 && codeLength == 1) {
                spacingText += wordSpacingText;
            }
            this.textMatrix.multiply(ctm, textXctm);
            Matrix textMatrixStart = textStateParameters.multiply(textXctm);
            float tx = characterHorizontalDisplacementText * fontSizeText * horizontalScalingText;
            float ty = 0.0f;
            td.reset();
            td.setValue(2, 0, tx);
            td.setValue(2, 1, ty);
            textStateParameters.multiply(td, tempMatrix);
            tempMatrix.multiply(textXctm, textMatrixEnd);
            float endXPosition = textMatrixEnd.getXPosition();
            float endYPosition = textMatrixEnd.getYPosition();
            tx = (characterHorizontalDisplacementText * fontSizeText + characterSpacingText + spacingText) * horizontalScalingText;
            td.setValue(2, 0, tx);
            td.multiply(this.textMatrix, this.textMatrix);
            float startXPosition = textMatrixStart.getXPosition();
            float widthText = endXPosition - startXPosition;
            if (c != null) {
                ++this.validCharCnt;
            } else {
                c = "?";
            }
            ++this.totalCharCnt;
            float totalVerticalDisplacementDisp = maxVerticalDisplacementText * fontSizeText * textXctm.getYScale();
            this.processTextPosition(new TextPosition(pageRotation, pageWidth, pageHeight, textMatrixStart, endXPosition, endYPosition, totalVerticalDisplacementDisp, widthText, spaceWidthDisp, c, codePoints, font, fontSizeText, (int)(fontSizeText * this.textMatrix.getXScale())));
        }
    }

    public void processOperator(String operation, List<COSBase> arguments) throws IOException {
        try {
            PDFOperator oper = PDFOperator.getOperator(operation);
            this.processOperator(oper, arguments);
        }
        catch (IOException e) {
            LOG.warn(e, e);
        }
    }

    protected void processOperator(PDFOperator operator, List<COSBase> arguments) throws IOException {
        try {
            String operation = operator.getOperation();
            OperatorProcessor processor = this.operators.get(operation);
            if (processor != null) {
                processor.setContext(this);
                processor.process(operator, arguments);
            } else if (!this.unsupportedOperators.contains(operation)) {
                LOG.info("unsupported/disabled operation: " + operation);
                this.unsupportedOperators.add(operation);
            }
        }
        catch (Exception e) {
            LOG.warn(e, e);
        }
    }

    public Map<String, PDColorSpace> getColorSpaces() {
        return this.streamResourcesStack.peek().getColorSpaces();
    }

    public Map<String, PDXObject> getXObjects() {
        return this.streamResourcesStack.peek().getXObjects();
    }

    public void setColorSpaces(Map<String, PDColorSpace> value) {
        this.streamResourcesStack.peek().setColorSpaces(value);
    }

    public Map<String, PDFont> getFonts() {
        if (this.streamResourcesStack.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.streamResourcesStack.peek().getFonts();
    }

    public void setFonts(Map<String, PDFont> value) {
        this.streamResourcesStack.peek().setFonts(value);
    }

    public Stack<PDGraphicsState> getGraphicsStack() {
        return this.graphicsStack;
    }

    public void setGraphicsStack(Stack<PDGraphicsState> value) {
        this.graphicsStack = value;
    }

    public PDGraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    public void setGraphicsState(PDGraphicsState value) {
        this.graphicsState = value;
    }

    public Map<String, PDExtendedGraphicsState> getGraphicsStates() {
        return this.streamResourcesStack.peek().getGraphicsStates();
    }

    public void setGraphicsStates(Map<String, PDExtendedGraphicsState> value) {
        this.streamResourcesStack.peek().setGraphicsStates(value);
    }

    public Matrix getTextLineMatrix() {
        return this.textLineMatrix;
    }

    public void setTextLineMatrix(Matrix value) {
        this.textLineMatrix = value;
    }

    public Matrix getTextMatrix() {
        return this.textMatrix;
    }

    public void setTextMatrix(Matrix value) {
        this.textMatrix = value;
    }

    public PDResources getResources() {
        return this.streamResourcesStack.peek();
    }

    public PDPage getCurrentPage() {
        return this.page;
    }

    public int getValidCharCnt() {
        return this.validCharCnt;
    }

    public int getTotalCharCnt() {
        return this.totalCharCnt;
    }
}

