/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImportImagePlugin;
import org.openstreetmap.josm.plugins.ImportImagePlugin.LayerPropertiesDialog;
import org.openstreetmap.josm.plugins.ImportImagePlugin.PluginOperations;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ImageLayer
extends Layer {
    private final File imageFile;
    private BufferedImage image;
    private EastNorth upperLeft;
    private double angle;
    private Envelope2D bbox;
    private Icon layericon;
    private CoordinateReferenceSystem sourceRefSys;

    public ImageLayer(File file) throws IOException {
        super(file.getName());
        this.imageFile = file;
        this.image = this.createImage();
        URL iconURL = ((Object)((Object)this)).getClass().getResource("images/layericon.png");
        if (iconURL != null) {
            this.layericon = new ImageIcon(iconURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createImage() throws IOException {
        GridCoverage2D coverage;
        try {
            coverage = PluginOperations.createGridFromFile(this.imageFile, null, true);
            this.sourceRefSys = coverage.getCoordinateReferenceSystem();
            coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)ProjectionRegistry.getProjection().toCode()));
        }
        catch (FactoryException e) {
            Logging.error((String)"ImportImagePlugin ImageLayer: Error while creating GridCoverage: {0}", (Object[])new Object[]{e});
            Logging.error((Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            if (e.getMessage().contains("No projection file found")) {
                int val = 2;
                if (!GraphicsEnvironment.isHeadless()) {
                    ExtendedDialog ex = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Warning", (Object[])new Object[0]), new String[]{I18n.tr((String)"Default image projection", (Object[])new Object[0]), I18n.tr((String)"JOSM''s current projection", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
                    ex.setContent(I18n.tr((String)"No projection file (.prj) found.<br>You can choose the default image projection ({0}) or JOSM''s current editor projection ({1}) as original image projection.<br>(It can be changed later from the right click menu of the image layer.)", (Object[])new Object[]{ImportImagePlugin.pluginProps.getProperty("default_crs_srid"), ProjectionRegistry.getProjection().toCode()}));
                    val = ex.showDialog().getValue();
                    if (val == 3) {
                        Logging.debug((String)"ImportImagePlugin ImageLayer: No projection and user declined un-projected use");
                        throw new LayerCreationCanceledException();
                    }
                }
                try {
                    CoordinateReferenceSystem src;
                    if (val == 1) {
                        src = PluginOperations.defaultSourceCRS;
                    } else {
                        Logging.debug((String)"ImportImagePlugin ImageLayer: Passing through image un-projected.");
                        src = CRS.decode((String)ProjectionRegistry.getProjection().toCode());
                    }
                    coverage = PluginOperations.createGridFromFile(this.imageFile, src, false);
                    this.sourceRefSys = coverage.getCoordinateReferenceSystem();
                    if (val == 1) {
                        coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)ProjectionRegistry.getProjection().toCode()));
                    }
                }
                catch (Exception e1) {
                    Logging.error((String)"ImportImagePlugin ImageLayer: Error while creating GridCoverage:");
                    Logging.error((Throwable)e1);
                    throw new IOException(e1);
                }
            }
            Logging.error((String)"ImportImagePlugin ImageLayer: Error while creating GridCoverage:");
            Logging.error((Throwable)e);
            throw new IOException(e);
        }
        Logging.debug((String)"ImportImagePlugin ImageLayer: Coverage created: {0}", (Object[])new Object[]{coverage});
        this.upperLeft = new EastNorth(coverage.getEnvelope2D().x, coverage.getEnvelope2D().y + coverage.getEnvelope2D().height);
        this.angle = 0.0;
        this.bbox = coverage.getEnvelope2D();
        RenderedImage img = coverage.getRenderedImage();
        try {
            BufferedImage bi = new ImageWorker(img).getBufferedImage();
            BufferedImage dst = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            Graphics2D g2d = dst.createGraphics();
            try {
                g2d.drawImage((Image)bi, 0, 0, null);
            }
            finally {
                g2d.dispose();
            }
            return bi;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logging.debug((Throwable)e);
            return new ImageWorker(img).rescaleToBytes().getBufferedImage();
        }
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bounds) {
        if (this.image != null && g2 != null) {
            EastNorth center = mv.getCenter();
            EastNorth leftop = mv.getEastNorth(0, 0);
            double pixel_per_east_unit = (double)mv.getWidth() / 2.0 / (center.east() - leftop.east());
            double pixel_per_north_unit = (double)mv.getHeight() / 2.0 / (leftop.north() - center.north());
            double pic_offset_x = (this.upperLeft.east() - leftop.east()) * pixel_per_east_unit;
            double pic_offset_y = (leftop.north() - this.upperLeft.north()) * pixel_per_north_unit;
            Graphics2D g = (Graphics2D)g2.create();
            g.translate(pic_offset_x, pic_offset_y);
            g.rotate(this.angle * Math.PI / 180.0);
            ProjectionBounds projbounds = mv.getProjectionBounds();
            double width = projbounds.maxEast - projbounds.minEast;
            double height = projbounds.maxNorth - projbounds.minNorth;
            double ratio_x = (this.bbox.getMaxX() - this.bbox.getMinX()) / width;
            double ratio_y = (this.bbox.getMaxY() - this.bbox.getMinY()) / height;
            double pixels4bbox_width = ratio_x * (double)mv.getWidth();
            double pixels4bbox_height = ratio_y * (double)mv.getHeight();
            double scalex = pixels4bbox_width / (double)this.image.getWidth();
            double scaley = pixels4bbox_height / (double)this.image.getHeight();
            if (scalex > 10.0 || scaley > 10.0) {
                Logging.warn((String)"ImportImagePlugin ImageLayer: Not drawing image - scale too big");
                return;
            }
            g.scale(scalex, scaley);
            try {
                g.drawImage((Image)this.image, 0, 0, null);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logging.error((Throwable)e);
            }
        } else {
            Logging.error((String)"ImportImagePlugin ImageLayer: Error while drawing image: image == null or Graphics == null");
        }
    }

    public Envelope2D getBbox() {
        return this.bbox;
    }

    public Icon getIcon() {
        return this.layericon;
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction((Layer)this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), new LayerPropertiesAction(this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
        throw new UnsupportedOperationException();
    }

    public void visitBoundingBox(BoundingXYVisitor visitor) {
        EastNorth min = new EastNorth(this.getBbox().getMinX(), this.getBbox().getMinY());
        EastNorth max = new EastNorth(this.getBbox().getMaxX(), this.getBbox().getMaxY());
        visitor.visit(min);
        visitor.visit(max);
    }

    public String getToolTipText() {
        return this.getName();
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    void resample(CoordinateReferenceSystem refSys) throws IOException, FactoryException {
        Logging.debug((String)"ImportImagePlugin ImageLayer: resample");
        GridCoverage2D coverage = PluginOperations.createGridFromFile(this.imageFile, refSys, true);
        coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)ProjectionRegistry.getProjection().toCode()));
        this.bbox = coverage.getEnvelope2D();
        this.image = ((PlanarImage)coverage.getRenderedImage()).getAsBufferedImage();
        this.upperLeft = new EastNorth(coverage.getEnvelope2D().x, coverage.getEnvelope2D().y + coverage.getEnvelope2D().height);
        this.angle = 0.0;
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        this.visitBoundingBox(boundingXYVisitor);
        MainApplication.getMap().mapView.zoomTo(boundingXYVisitor);
    }

    public CoordinateReferenceSystem getSourceRefSys() {
        return this.sourceRefSys;
    }

    public void setSourceRefSys(CoordinateReferenceSystem sourceRefSys) {
        this.sourceRefSys = sourceRefSys;
    }

    static class LayerCreationCanceledException
    extends IOException {
        LayerCreationCanceledException() {
        }
    }

    public static class LayerPropertiesAction
    extends AbstractAction {
        public ImageLayer imageLayer;

        public LayerPropertiesAction(ImageLayer imageLayer) {
            super(I18n.tr((String)"Layer Properties", (Object[])new Object[0]));
            this.imageLayer = imageLayer;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LayerPropertiesDialog layerProps = new LayerPropertiesDialog(this.imageLayer, PluginOperations.crsDescriptions);
            layerProps.setLocation(MainApplication.getMainFrame().getWidth() / 4, MainApplication.getMainFrame().getHeight() / 4);
            layerProps.setVisible(true);
        }
    }
}

