/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geojson;

import java.util.Optional;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.plugins.geojson.GeoJsonServerReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class GeoJsonDownloadTask
extends DownloadOsmTask {
    private static final String PATTERN_COMPRESS = "https?://.*/(.*\\.(json|geojson)(\\.(gz|xz|bz2?|zip))?)";

    public String[] getPatterns() {
        return new String[]{PATTERN_COMPRESS};
    }

    public String getTitle() {
        return I18n.tr((String)"Download GeoJSON", (Object[])new Object[0]);
    }

    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new InternalDownloadTask(settings, url, progressMonitor);
        return MainApplication.worker.submit((Runnable)this.downloadTask);
    }

    class InternalDownloadTask
    extends DownloadOsmTask.DownloadTask {
        private final String url;

        InternalDownloadTask(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
            super((DownloadOsmTask)GeoJsonDownloadTask.this, settings, (OsmServerReader)new GeoJsonServerReader(url), progressMonitor);
            this.url = url;
        }

        protected String generateLayerName() {
            return Optional.of(this.url.substring(this.url.lastIndexOf(47) + 1)).filter(it -> !Utils.isStripEmpty((String)it)).orElse(super.generateLayerName());
        }

        protected OsmDataLayer createNewLayer(DataSet dataSet, Optional<String> layerName) {
            if (layerName.filter(Utils::isStripEmpty).isPresent()) {
                throw new IllegalArgumentException("Blank layer name!");
            }
            return new OsmDataLayer(dataSet, layerName.orElseGet(this::generateLayerName), null);
        }
    }
}

