/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectModWaysAction
extends JosmAction {
    private Command lastCmd;

    public SelectModWaysAction() {
        super(I18n.tr((String)"Select last modified ways", (Object[])new Object[0]), "selmodways", I18n.tr((String)"Select last modified ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selmodways", (String)I18n.tr((String)"Selection: {0}", (Object[])new Object[]{I18n.tr((String)"Select last modified ways", (Object[])new Object[0])}), (int)90, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectLastModifiedWays"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.clearSelection(ds.getSelectedNodes());
            int num = UndoRedoHandler.getInstance().getUndoCommands().size();
            if (num == 0) {
                return;
            }
            int k = 0;
            int idx = this.lastCmd != null && !ds.getSelectedWays().isEmpty() ? UndoRedoHandler.getInstance().getUndoCommands().lastIndexOf(this.lastCmd) : num;
            HashSet<Way> ways = new HashSet<Way>(10);
            do {
                idx = idx > 0 ? --idx : num - 1;
                Command cmd = (Command)UndoRedoHandler.getInstance().getUndoCommands().get(idx);
                if (cmd.getAffectedDataSet() != ds) continue;
                Collection pp = cmd.getParticipatingPrimitives();
                ways.clear();
                for (OsmPrimitive p : pp) {
                    if (!(p instanceof Way) || p.isDeleted() || p.isDisabled()) continue;
                    ways.add((Way)p);
                }
                if (ways.isEmpty() || ds.getSelectedWays().containsAll(ways)) continue;
                ds.setSelected(ways);
                this.lastCmd = cmd;
                return;
            } while (++k < num);
            this.lastCmd = null;
        }
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    protected void updateEnabledState() {
        boolean hasEditLayer;
        boolean bl = hasEditLayer = this.getLayerManager().getEditDataSet() != null;
        if (!hasEditLayer) {
            this.lastCmd = null;
        }
        this.setEnabled(hasEditLayer);
    }
}

