/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.plugins.fastdraw.DrawnPolyLine;
import org.openstreetmap.josm.plugins.fastdraw.FDSettings;
import org.openstreetmap.josm.plugins.fastdraw.FastDrawConfigDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.TextTagParser;

class FastDrawingMode
extends MapMode
implements MapViewPaintable,
KeyPressReleaseListener,
ModifierExListener {
    private static final String SIMPLIFYMODE_MESSAGE = I18n.tr((String)"Q=Options, Enter=save, Ctrl-Enter=save with tags, Up/Down=tune", (Object[])new Object[0]);
    private static final String DRAWINGMODE_MESSAGE = I18n.tr((String)"Click or Click&drag to continue, Ctrl-Click to add fixed node, Shift-Click to delete, Enter to simplify or save, Ctrl-Shift-Click to start new line", (Object[])new Object[0]);
    private FDSettings settings;
    private final DrawnPolyLine line;
    private MapView mv;
    private String statusText;
    private boolean drawing;
    private double eps;
    private final Cursor cursorDraw;
    private final Cursor cursorCtrl;
    private final Cursor cursorShift;
    private final Cursor cursorReady;
    private final Cursor cursorDrawing;
    private boolean nearSomeNode;
    private LatLon highlightedFragmentStart;
    private int nearestPointIndex;
    private int dragNode = -1;
    private List<Node> oldNodes;
    private boolean lineWasSaved;
    private boolean deltaChanged;
    private Way oldWay;
    private final ArrayList<Point> fixedPoints = new ArrayList(3000);

    FastDrawingMode(MapFrame mapFrame) {
        super(I18n.tr((String)"FastDrawing", (Object[])new Object[0]), "turbopen.png", I18n.tr((String)"Fast drawing mode", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:fastdraw", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Fast drawing mode", (Object[])new Object[0])}), (int)70, (int)5005), Cursor.getPredefinedCursor(0));
        this.line = new DrawnPolyLine();
        this.cursorDraw = ImageProvider.getCursor((String)"crosshair", null);
        this.cursorCtrl = ImageProvider.getCursor((String)"crosshair", (String)"fixed");
        this.cursorShift = ImageProvider.getCursor((String)"crosshair", (String)"new");
        this.cursorReady = ImageProvider.getCursor((String)"crosshair", (String)"ready");
        this.cursorDrawing = ImageProvider.getCursor((String)"crosshair", (String)"mode");
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.lineWasSaved = false;
        this.settings = new FDSettings();
        this.settings.loadPrefs();
        this.settings.savePrefs();
        MapFrame map = MainApplication.getMap();
        this.eps = this.settings.startingEps;
        this.mv = map.mapView;
        this.line.setMv(this.mv);
        if (this.getLayerManager().getEditDataSet() == null) {
            return;
        }
        map.mapView.addMouseListener((MouseListener)((Object)this));
        map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        map.mapView.addTemporaryLayer((MapViewPaintable)this);
        map.keyDetector.addKeyListener((KeyPressReleaseListener)this);
        map.keyDetector.addModifierExListener((ModifierExListener)this);
    }

    public void exitMode() {
        super.exitMode();
        if (this.line.wasSimplified() && !this.lineWasSaved) {
            this.saveAsWay(false);
        }
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener((MouseListener)((Object)this));
        map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        map.keyDetector.removeKeyListener((KeyPressReleaseListener)this);
        map.keyDetector.removeModifierExListener((ModifierExListener)this);
        this.settings.savePrefs();
        map.mapView.setCursor(this.cursorDraw);
        this.repaint();
    }

    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        Point lp;
        Color initLineColor;
        LinkedList<LatLon> pts = this.line.getPoints();
        if (pts.isEmpty()) {
            return;
        }
        if (this.line.wasSimplified()) {
            g.setStroke(this.settings.simplifiedStroke);
        } else {
            g.setStroke(this.settings.normalStroke);
        }
        int bigDotSize = this.settings.bigDotSize;
        Point p1 = this.line.getPoint(pts.get(0));
        g.setColor(this.settings.COLOR_FIXED.get());
        g.fillOval(p1.x - bigDotSize / 2, p1.y - bigDotSize / 2, bigDotSize, bigDotSize);
        Color lineColor = initLineColor = this.line.wasSimplified() ? this.settings.COLOR_SIMPLIFIED.get() : this.settings.COLOR_NORMAL.get();
        int dp = this.line.wasSimplified() ? this.settings.bigDotSize : this.settings.dotSize;
        int rp = dp / 2;
        if (pts.size() > 1) {
            ListIterator<LatLon> it1 = pts.listIterator(0);
            ListIterator<LatLon> it2 = pts.listIterator(1);
            this.fixedPoints.clear();
            for (int i = 0; i < pts.size() - 1; ++i) {
                LatLon pp1 = (LatLon)it1.next();
                p1 = this.line.getPoint(pp1);
                LatLon pp2 = (LatLon)it2.next();
                Point p2 = this.line.getPoint(pp2);
                if (this.shift && this.highlightedFragmentStart == pp1 && this.nearestPointIndex < 0) {
                    lineColor = this.settings.COLOR_SELECTEDFRAGMENT.get();
                }
                if (!this.shift && this.line.isLastPoint(i)) {
                    lineColor = this.settings.COLOR_EDITEDFRAGMENT.get();
                }
                g.setColor(lineColor);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
                if (this.line.isFixed(pp2)) {
                    lineColor = initLineColor;
                    this.fixedPoints.add(p2);
                } else {
                    g.fillRect(p2.x - rp, p2.y - rp, dp, dp);
                }
                if (this.drawing || this.line.wasSimplified() || this.nearestPointIndex != i + 1) continue;
                if (this.shift) {
                    g.setStroke(this.settings.deleteStroke);
                    g.setColor(this.settings.COLOR_DELETE.get());
                    g.drawLine(p2.x - 5, p2.y - 5, p2.x + 5, p2.y + 5);
                    g.drawLine(p2.x - 5, p2.y + 5, p2.x + 5, p2.y - 5);
                    g.setStroke(this.settings.normalStroke);
                    continue;
                }
                if (!this.ctrl) continue;
                g.setStroke(this.settings.deleteStroke);
                g.setColor(this.line.isFixed(pp2) ? this.settings.COLOR_NORMAL.get() : this.settings.COLOR_FIXED.get());
                g.fillOval(p2.x - bigDotSize / 2 - 2, p2.y - bigDotSize / 2 - 2, bigDotSize + 4, bigDotSize + 4);
                g.setStroke(this.settings.normalStroke);
            }
            g.setColor(this.settings.COLOR_FIXED.get());
            for (Point p : this.fixedPoints) {
                g.fillOval(p.x - bigDotSize / 2, p.y - bigDotSize / 2, bigDotSize, bigDotSize);
            }
        }
        if (this.settings.drawLastSegment && !this.drawing && this.dragNode < 0 && !this.shift && this.nearestPointIndex <= 0 && !this.line.wasSimplified()) {
            g.setColor(lineColor);
            lp = this.line.getLastPoint();
            Point mp = mv.getMousePosition();
            if (lp != null && mp != null) {
                g.drawLine(lp.x, lp.y, mp.x, mp.y);
            }
        }
        if (this.deltaChanged) {
            g.setColor(lineColor);
            lp = this.line.getLastPoint();
            int r = (int)this.settings.minPixelsBetweenPoints;
            if (lp != null) {
                g.drawOval(lp.x - r, lp.y - r, 2 * r, 2 * r);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.updateKeyModifiers(e);
        this.requestFocusInMapView();
        int idx = this.line.findClosestPoint(e.getPoint(), this.settings.maxDist);
        if (idx == 0 && !this.line.isClosed()) {
            this.line.closeLine();
            this.drawing = false;
            this.dragNode = 0;
            this.updateCursor();
            return;
        }
        this.autoCloseIfNeeded();
        if (this.ctrl && this.shift) {
            this.newDrawing();
            this.repaint();
            return;
        }
        if (!this.ctrl && this.shift) {
            if (idx >= 0) {
                this.line.deleteNode(idx);
                this.nearestPointIndex = -1;
            } else {
                this.line.tryToDeleteSegment(e.getPoint());
            }
            return;
        }
        if (idx >= 0) {
            if (this.ctrl) {
                this.line.toggleFixed(idx);
            }
            this.dragNode = idx;
            return;
        }
        this.startDrawing(e.getPoint(), this.settings.fixedClick);
    }

    private void startDrawing(Point point, boolean fixFlag) {
        Node nd1;
        this.drawing = true;
        if (this.line.wasSimplified()) {
            this.saveAsWay(false);
            this.newDrawing();
        }
        LatLon p = this.mv.getLatLon(point.x, point.y);
        if (this.settings.snapNodes && (nd1 = this.getNearestNode(point, this.settings.maxDist)) != null) {
            p = nd1.getCoor();
            this.line.fixPoint(p);
        }
        this.line.addLast(p);
        if (this.ctrl || fixFlag) {
            this.line.fixPoint(p);
        }
        this.setStatusLine(I18n.tr((String)"Please move the mouse to draw new way", (Object[])new Object[0]));
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.stopDrawing();
    }

    private void stopDrawing() {
        if (!this.isEnabled()) {
            return;
        }
        this.dragNode = -1;
        this.drawing = false;
        this.highlightedFragmentStart = null;
        if (!this.line.isClosed()) {
            this.setStatusLine(DRAWINGMODE_MESSAGE);
        }
        this.updateCursor();
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        int nearestIdx2;
        if (!this.isEnabled()) {
            return;
        }
        this.updateKeyModifiers(e);
        this.deltaChanged = false;
        Node nd1 = this.getNearestNode(e.getPoint(), this.settings.maxDist);
        boolean nearSomeNode2 = nd1 != null;
        boolean needRepaint = false;
        if (this.nearSomeNode != nearSomeNode2) {
            this.nearSomeNode = nearSomeNode2;
            this.updateCursor();
            needRepaint = true;
        }
        if (this.nearestPointIndex != (nearestIdx2 = this.line.findClosestPoint(e.getPoint(), this.settings.maxDist))) {
            this.nearestPointIndex = nearestIdx2;
            this.updateCursor();
            needRepaint = true;
        }
        if (this.settings.drawLastSegment) {
            needRepaint = true;
        }
        if (!this.drawing) {
            LatLon h2;
            if (this.dragNode >= 0 && this.dragNode < this.line.getPointCount()) {
                this.line.moveNode(this.dragNode, this.getLatLon(e));
                this.repaint();
                return;
            }
            if (this.shift && this.nearestPointIndex == -1 && this.highlightedFragmentStart != (h2 = this.line.findBigSegment(e.getPoint()))) {
                this.highlightedFragmentStart = h2;
                needRepaint = true;
            }
            if (needRepaint) {
                this.repaint();
            }
            return;
        }
        if (this.line.isClosed()) {
            this.setStatusLine(SIMPLIFYMODE_MESSAGE);
        }
        if (this.nearestPointIndex >= 0) {
            return;
        }
        Point lastP = this.line.getLastPoint();
        if (this.nearSomeNode) {
            if (this.settings.snapNodes && lastP != null && Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > 0.01) {
                this.line.addFixed(nd1.getCoor());
                this.repaint();
                return;
            }
        } else if (lastP != null && Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > this.settings.minPixelsBetweenPoints) {
            this.line.addLast(this.getLatLon(e));
            this.repaint();
            return;
        }
        this.autoCloseIfNeeded();
    }

    public void doKeyPressed(KeyEvent e) {
        if (this.getShortcut().isEvent(e)) {
            this.tryToLoadWay();
            return;
        }
        switch (e.getKeyCode()) {
            case 8: {
                if (this.line.wasSimplified()) {
                    this.line.clearSimplifiedVersion();
                    this.repaint();
                    this.eps = this.settings.startingEps;
                }
                this.back();
                break;
            }
            case 10: {
                e.consume();
                if (!this.line.wasSimplified()) {
                    switch (this.settings.simplifyMode) {
                        case 0: {
                            this.eps = this.line.autoSimplify(this.settings.startingEps, this.settings.epsilonMult, this.settings.pkmBlockSize, this.settings.maxPointsPerKm);
                            break;
                        }
                        case 1: {
                            this.line.simplify(this.eps);
                        }
                    }
                    if (this.settings.simplifyMode == 2) {
                        this.saveAsWay(true);
                        break;
                    }
                    this.repaint();
                    this.showSimplifyHint();
                    break;
                }
                this.saveAsWay(true);
                break;
            }
            case 40: {
                if (this.ctrl || this.shift || this.alt) {
                    return;
                }
                e.consume();
                if (this.line.wasSimplified()) {
                    this.changeEpsilon(this.settings.epsilonMult);
                    break;
                }
                this.changeDelta(0.9090909090909091);
                break;
            }
            case 38: {
                if (this.ctrl || this.shift || this.alt) {
                    return;
                }
                e.consume();
                if (this.line.wasSimplified()) {
                    this.changeEpsilon(1.0 / this.settings.epsilonMult);
                    break;
                }
                this.changeDelta(1.1);
                break;
            }
            case 27: {
                boolean answer;
                e.consume();
                Point lastPoint = this.line.getLastPoint();
                if (!this.line.isClosed()) {
                    this.line.moveToTheEnd();
                }
                if (lastPoint != null && !lastPoint.equals(this.line.getLastPoint()) || this.line.getPoints().size() > 5 && !(answer = ConditionalOptionPaneUtil.showConfirmationDialog((String)"delete_drawn_line", (Component)MainApplication.getMainFrame(), (Object)I18n.tr((String)"Are you sure you do not want to save the line containing {0} points?", (Object[])new Object[]{this.line.getPoints().size()}), (String)I18n.tr((String)"Delete confirmation", (Object[])new Object[0]), (int)0, (int)3, (int)0))) break;
                this.newDrawing();
                MainApplication.getMap().selectSelectTool(false);
                break;
            }
            case 73: {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"{0} m - length of the line\n{1} nodes\n{2} points per km (maximum)\n{3} points per km (average)", (Object[])new Object[]{this.line.getLength(), this.line.getPoints().size(), this.line.getNodesPerKm(this.settings.pkmBlockSize), this.line.getNodesPerKm(1000000)}), I18n.tr((String)"Line information", (Object[])new Object[0]), 1);
                break;
            }
            case 81: {
                e.consume();
                new FastDrawConfigDialog(this.settings).showDialog();
                if (this.line.wasSimplified()) {
                    this.eps = this.line.autoSimplify(this.settings.startingEps, this.settings.epsilonMult, this.settings.pkmBlockSize, this.settings.maxPointsPerKm);
                    this.showSimplifyHint();
                }
                this.repaint();
                break;
            }
            case 32: {
                Point p;
                e.consume();
                if (this.drawing || (p = MainApplication.getMap().mapView.getMousePosition()) == null) break;
                this.startDrawing(p, this.settings.fixedSpacebar);
            }
        }
    }

    public void doKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.stopDrawing();
        }
        this.updateCursor();
    }

    public void modifiersExChanged(int modifiers) {
        this.updateKeyModifiersEx(modifiers);
        this.updateCursor();
    }

    protected void updateStatusLine() {
        MainApplication.getMap().statusLine.setHelpText(this.statusText);
        MainApplication.getMap().statusLine.repaint();
    }

    public void newDrawing() {
        this.oldWay = null;
        this.oldNodes = null;
        this.eps = this.settings.startingEps;
        this.line.clear();
    }

    private void saveAsWay(boolean autoExit) {
        Way w;
        DataSet ds;
        LinkedList<LatLon> pts = this.line.getPoints();
        int n = pts.size();
        if (n < 2) {
            return;
        }
        if (this.line.isClosed() && n == 2) {
            return;
        }
        if (this.line.isClosed() && n == 3) {
            pts.remove(2);
        }
        if ((ds = this.getLayerManager().getEditDataSet()) == null) {
            return;
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        int i = 0;
        if (this.oldWay == null) {
            w = new Way();
        } else {
            w = new Way(this.oldWay);
            w.setNodes(new ArrayList());
        }
        LatLon first = (LatLon)pts.get(0);
        Node firstNode = null;
        for (LatLon p : pts) {
            Node nd = MainApplication.getMap().mapView.getNearestNode(this.line.getPoint(p), OsmPrimitive::isSelectable);
            if (nd != null && p.greatCircleDistance((ILatLon)nd) > 0.01) {
                nd = null;
            }
            if (nd == null) {
                if (i > 0 && p.equals((Object)first)) {
                    nd = firstNode;
                } else {
                    nd = new Node(p);
                    cmds.add(new AddCommand(ds, (OsmPrimitive)nd));
                }
            }
            if (nd.isOutSideWorld()) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Cannot place node outside of the world.", (Object[])new Object[0]));
                return;
            }
            if (i == 0) {
                firstNode = nd;
            }
            w.addNode(nd);
            ++i;
        }
        if (this.ctrl) {
            new OsmTransferHandler().pasteTags(Collections.singleton(w));
        }
        if (!this.settings.autoTags.isEmpty()) {
            Map tags = TextTagParser.readTagsFromText((String)this.settings.autoTags);
            for (String k : tags.keySet()) {
                w.put(k, (String)tags.get(k));
            }
        }
        if (this.oldWay != null) {
            List nodes = w.getNodes();
            cmds.add(new ChangeCommand((OsmPrimitive)this.oldWay, (OsmPrimitive)w));
            for (Node nd : this.oldNodes) {
                List refs;
                if (nodes.contains(nd) || (refs = nd.getReferrers()).size() != 1 || nd.isDeleted() || !nd.isUsable() || nd.isTagged()) continue;
                cmds.add(new DeleteCommand((OsmPrimitive)nd));
            }
            this.oldWay = null;
        } else {
            cmds.add(new AddCommand(ds, (OsmPrimitive)w));
        }
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Draw the way by mouse", (Object[])new Object[0]), cmds);
        UndoRedoHandler.getInstance().add((Command)c);
        this.lineWasSaved = true;
        this.newDrawing();
        if (autoExit) {
            ds.setSelected(new PrimitiveId[]{w});
            MainApplication.getMap().selectSelectTool(false);
        }
    }

    public void back() {
        this.line.undo();
        this.repaint();
    }

    void changeEpsilon(double k) {
        this.eps *= k;
        this.line.simplify(this.eps);
        this.showSimplifyHint();
        this.repaint();
    }

    void changeDelta(double k) {
        this.settings.minPixelsBetweenPoints *= k;
        this.deltaChanged = true;
        this.setStatusLine(I18n.tr((String)"min distance={0} px ({1} m)", (Object[])new Object[]{(int)this.settings.minPixelsBetweenPoints, this.mv.getDist100Pixel() / 100.0 * this.settings.minPixelsBetweenPoints}));
        this.repaint();
    }

    private void loadFromWay(Way w) {
        Object[] nodes = w.getNodes().toArray();
        int n = nodes.length;
        if (w.isClosed()) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            Node nd = (Node)nodes[i];
            List refs = nd.getReferrers();
            if (refs.size() > 1 || nd.isTagged()) {
                this.line.addFixed(nd.getCoor());
                continue;
            }
            this.line.addLast(nd.getCoor());
        }
        if (w.isClosed()) {
            this.line.closeLine();
        }
        this.oldNodes = w.getNodes();
        this.oldWay = w;
    }

    private void setStatusLine(String tr) {
        this.statusText = tr;
        this.updateStatusLine();
    }

    private void showSimplifyHint() {
        this.setStatusLine(I18n.tr((String)"Eps={0}, {1} points, {2} p/km", (Object[])new Object[]{this.eps, this.line.getSimplePointsCount(), this.line.getNodesPerKm(this.settings.pkmBlockSize)}) + " " + SIMPLIFYMODE_MESSAGE);
    }

    private void updateCursor() {
        MapView mapView = MainApplication.getMap().mapView;
        if (this.shift) {
            mapView.setCursor(this.cursorShift);
        } else if (this.line.isClosed() || this.nearestPointIndex == 0) {
            mapView.setCursor(this.cursorReady);
        } else if (this.ctrl) {
            mapView.setCursor(this.cursorCtrl);
        } else if (this.nearSomeNode && this.settings.snapNodes) {
            mapView.setCursor(this.cursorCtrl);
        } else if (this.drawing) {
            mapView.setCursor(this.cursorDrawing);
        } else {
            mapView.setCursor(this.cursorDraw);
        }
    }

    private void repaint() {
        MainApplication.getMap().mapView.repaint();
    }

    private void tryToLoadWay() {
        Way w;
        this.updateCursor();
        Collection selectedWays = MainApplication.getLayerManager().getEditDataSet().getSelectedWays();
        if (selectedWays != null && selectedWays.size() == 1 && this.line.getPoints().size() == 0 && ((w = (Way)selectedWays.iterator().next()).isNew() || this.settings.allowEditExistingWays)) {
            this.loadFromWay(w);
        }
    }

    private void autoCloseIfNeeded() {
        if (this.settings.drawClosed && this.line.getPointCount() > 1 && !this.line.isClosed()) {
            this.line.closeLine();
        }
    }

    private Node getNearestNode(Point point, double maxDist) {
        Node nd = MainApplication.getMap().mapView.getNearestNode(point, OsmPrimitive::isSelectable);
        if (nd != null && this.line.getPoint(nd.getCoor()).distance(point) <= maxDist) {
            return nd;
        }
        return null;
    }

    LatLon getLatLon(MouseEvent e) {
        return this.mv.getLatLon(e.getX(), e.getY());
    }
}

