/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.internal.function.calc.Calculator;
import tech.units.indriya.spi.NumberSystem;
import tech.uom.lib.common.function.ValueSupplier;

public final class AddConverter
extends AbstractConverter
implements ValueSupplier<Number> {
    private static final long serialVersionUID = -2981335308595652284L;
    private final Number offset;

    public AddConverter(Number offset) {
        this.offset = Calculus.currentNumberSystem().narrow(offset);
    }

    public Number getOffset() {
        return this.offset;
    }

    @Override
    public boolean isIdentity() {
        return Calculus.currentNumberSystem().isZero(this.offset);
    }

    @Override
    protected boolean canReduceWith(AbstractConverter that) {
        return that instanceof AddConverter;
    }

    @Override
    protected AbstractConverter reduce(AbstractConverter that) {
        NumberSystem ns = Calculus.currentNumberSystem();
        Number newOffset = ns.add(this.offset, ((AddConverter)that).offset);
        return new AddConverter(newOffset);
    }

    @Override
    public AddConverter inverseWhenNotIdentity() {
        NumberSystem ns = Calculus.currentNumberSystem();
        Number newOffset = ns.negate(this.offset);
        return new AddConverter(newOffset);
    }

    @Override
    protected Number convertWhenNotIdentity(Number value) {
        return Calculator.of(this.offset).add(value).peek();
    }

    @Override
    public String transformationLiteral() {
        NumberSystem ns = Calculus.currentNumberSystem();
        int signum = ns.signum(this.offset);
        return String.format("x -> x %s %s", signum < 0 ? "-" : "+", ns.abs(this.offset));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AddConverter) {
            AddConverter other = (AddConverter)obj;
            return Objects.equals(this.offset, other.offset);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.offset);
    }

    @Override
    public boolean isLinear() {
        return this.isIdentity();
    }

    @Override
    public Number getValue() {
        return this.offset;
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof AddConverter) {
            NumberSystem ns = Calculus.currentNumberSystem();
            return ns.compare(this.getValue(), ((AddConverter)o).getValue());
        }
        return -1;
    }
}

