/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common.ancient;

import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;

public enum VedicPrefix implements Prefix
{
    EK("E", 1, 1),
    DAS("D", 10, 1),
    SAU("S", 10, 2),
    SAHASR("SA", 10, 3),
    LAKH("Lk", 10, 5),
    CRORE("cr", 10, 7),
    ARAWB("A", 10, 9),
    KHARAWB("K", 10, 11),
    NEEL("N", 10, 13),
    PADMA("Pa", 10, 15),
    SHANKH("SH", 10, 17),
    MAHASHANKH("M", 10, 19);

    private final String symbol;
    private final int base;
    private final int exponent;

    private VedicPrefix(String symbol, int base, int exponent) {
        this.symbol = symbol;
        this.base = base;
        this.exponent = exponent;
    }

    @Override
    public Integer getValue() {
        return this.base;
    }

    @Override
    public int getExponent() {
        return this.exponent;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static final <Q extends Quantity<Q>> Unit<Q> EK(Unit<Q> unit) {
        return unit;
    }

    public static final <Q extends Quantity<Q>> Unit<Q> DAS(Unit<Q> unit) {
        return unit.prefix(DAS);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> SAU(Unit<Q> unit) {
        return unit.prefix(SAU);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> SAHASR(Unit<Q> unit) {
        return unit.prefix(SAHASR);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> HAZAAR(Unit<Q> unit) {
        return VedicPrefix.SAHASR(unit);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> LAKH(Unit<Q> unit) {
        return unit.prefix(LAKH);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> CRORE(Unit<Q> unit) {
        return unit.prefix(CRORE);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> ARAWB(Unit<Q> unit) {
        return unit.prefix(ARAWB);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> KHARAWB(Unit<Q> unit) {
        return unit.prefix(KHARAWB);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> NEEL(Unit<Q> unit) {
        return unit.prefix(NEEL);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> PADMA(Unit<Q> unit) {
        return unit.prefix(PADMA);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> SHANKH(Unit<Q> unit) {
        return unit.prefix(SHANKH);
    }

    public static final <Q extends Quantity<Q>> Unit<Q> MAHASHANKH(Unit<Q> unit) {
        return unit.prefix(MAHASHANKH);
    }
}

