/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.geotools.feature.NameImpl;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

public abstract class FilterAbstract
implements Filter {
    protected FilterAbstract() {
    }

    public boolean accepts(SimpleFeature feature) {
        return this.evaluate(feature);
    }

    private Object unpack(Object value) {
        if (value instanceof ComplexAttribute) {
            Property simpleContent = ((ComplexAttribute)value).getProperty(new NameImpl("simpleContent"));
            if (simpleContent == null) {
                return null;
            }
            return simpleContent.getValue();
        }
        if (value instanceof Attribute) {
            return ((Attribute)value).getValue();
        }
        return value;
    }

    protected Object eval(Expression expression, Object object) {
        if (expression == null) {
            return null;
        }
        Object value = expression.evaluate(object);
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object member : (Collection)value) {
                list.add(this.unpack(member));
            }
            return list;
        }
        return this.unpack(value);
    }

    protected Object eval(Expression expression, Object object, Class<?> context) {
        if (expression == null) {
            return null;
        }
        return expression.evaluate(object, context);
    }
}

