/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.datasource;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.geotools.data.jdbc.datasource.DataSourceFactorySpi;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.logging.Logging;

public final class DataSourceFinder {
    protected static final Logger LOGGER = Logging.getLogger(DataSourceFinder.class);
    private static volatile FactoryRegistry registry;

    private DataSourceFinder() {
    }

    public static synchronized DataSource getDataSource(Map<String, ?> params) throws IOException {
        Iterator<DataSourceFactorySpi> ps = DataSourceFinder.getAvailableDataSources();
        while (ps.hasNext()) {
            DataSourceFactorySpi fac = ps.next();
            try {
                if (!fac.canProcess(params)) continue;
                return fac.createDataSource(params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not acquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static synchronized UnWrapper getUnWrapper(Connection conn) throws IOException {
        Iterator<UnWrapper> ps = DataSourceFinder.getUnWrappers();
        while (ps.hasNext()) {
            UnWrapper uw = ps.next();
            try {
                if (!uw.canUnwrap(conn)) continue;
                return uw;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not test  " + uw + " for unwrapping abilities agaist " + conn, t);
            }
        }
        return null;
    }

    public static synchronized UnWrapper getUnWrapper(Statement st) throws IOException {
        Iterator<UnWrapper> ps = DataSourceFinder.getUnWrappers();
        while (ps.hasNext()) {
            UnWrapper uw = ps.next();
            try {
                if (!uw.canUnwrap(st)) continue;
                return uw;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not test  " + uw + " for unwrapping abilities agaist " + st, t);
            }
        }
        return null;
    }

    public static synchronized Iterator<DataSourceFactorySpi> getAvailableDataSources() {
        Stream<DataSourceFactorySpi> factories = DataSourceFinder.getServiceRegistry().getFactories(DataSourceFactorySpi.class, null, null);
        Set availableDS = factories.filter(dsFactory -> dsFactory.isAvailable()).collect(Collectors.toCollection(HashSet::new));
        return availableDS.iterator();
    }

    public static synchronized Iterator<UnWrapper> getUnWrappers() {
        return DataSourceFinder.getServiceRegistry().getFactories(UnWrapper.class, null, null).iterator();
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DataSourceFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DataSourceFactorySpi.class, UnWrapper.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DataSourceFinder.getServiceRegistry().scanForPlugins();
    }
}

