/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.ArrayDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.StateTransitionException;
import org.ehcache.Status;
import org.ehcache.core.InternalStatus;
import org.ehcache.core.events.StateChangeListener;
import org.ehcache.core.spi.LifeCycled;
import org.slf4j.Logger;

final class StatusTransitioner {
    private final AtomicReference<InternalStatus.Transition> currentState;
    private volatile Thread maintenanceLease;
    private final Logger logger;
    private final CopyOnWriteArrayList<LifeCycled> hooks = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<StateChangeListener> listeners = new CopyOnWriteArrayList();

    StatusTransitioner(Logger logger) {
        this.currentState = new AtomicReference<InternalStatus.Transition>(InternalStatus.initial());
        this.logger = logger;
    }

    Status currentStatus() {
        return this.currentState.get().get().toPublicStatus();
    }

    boolean isTransitioning() {
        return !this.currentState.get().done();
    }

    void checkAvailable() {
        Status status = this.currentStatus();
        if (status == Status.MAINTENANCE && Thread.currentThread() != this.maintenanceLease) {
            throw new IllegalStateException("State is " + (Object)((Object)status) + ", yet you don't own it!");
        }
        if (status == Status.UNINITIALIZED) {
            throw new IllegalStateException("State is " + (Object)((Object)status));
        }
    }

    void checkMaintenance() {
        Status status = this.currentStatus();
        if (status == Status.MAINTENANCE && Thread.currentThread() != this.maintenanceLease) {
            throw new IllegalStateException("State is " + (Object)((Object)status) + ", yet you don't own it!");
        }
        if (status != Status.MAINTENANCE) {
            throw new IllegalStateException("State is " + (Object)((Object)status));
        }
    }

    Transition init() {
        InternalStatus.Transition st;
        InternalStatus.Transition cs;
        this.logger.trace("Initializing");
        while (!this.currentState.compareAndSet(cs = this.currentState.get(), st = cs.get().init())) {
        }
        return new Transition(st, null, "Initialize");
    }

    Transition close() {
        InternalStatus.Transition st;
        InternalStatus.Transition cs;
        this.logger.trace("Closing");
        if (this.maintenanceLease != null && Thread.currentThread() != this.maintenanceLease) {
            throw new IllegalStateException("You don't own this MAINTENANCE lease");
        }
        while (!this.currentState.compareAndSet(cs = this.currentState.get(), st = cs.get().close())) {
        }
        return new Transition(st, null, "Close");
    }

    Transition maintenance() {
        InternalStatus.Transition st;
        InternalStatus.Transition cs;
        this.logger.trace("Entering Maintenance");
        while (!this.currentState.compareAndSet(cs = this.currentState.get(), st = cs.get().maintenance())) {
        }
        return new Transition(st, Thread.currentThread(), "Enter Maintenance");
    }

    Transition exitMaintenance() {
        InternalStatus.Transition st;
        InternalStatus.Transition cs;
        this.checkMaintenance();
        this.logger.trace("Exiting Maintenance");
        while (!this.currentState.compareAndSet(cs = this.currentState.get(), st = cs.get().close())) {
        }
        return new Transition(st, Thread.currentThread(), "Exit Maintenance");
    }

    void addHook(LifeCycled hook) {
        this.validateHookRegistration();
        this.hooks.add(hook);
    }

    void removeHook(LifeCycled hook) {
        this.validateHookRegistration();
        this.hooks.remove(hook);
    }

    private void validateHookRegistration() {
        if (this.currentStatus() != Status.UNINITIALIZED) {
            throw new IllegalStateException("Can't modify hooks when not in " + (Object)((Object)Status.UNINITIALIZED));
        }
    }

    void registerListener(StateChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    void deregisterListener(StateChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void runInitHooks() throws Exception {
        ArrayDeque<LifeCycled> initiated = new ArrayDeque<LifeCycled>();
        for (LifeCycled hook : this.hooks) {
            try {
                hook.init();
                initiated.add(hook);
            }
            catch (Exception initException) {
                while (!initiated.isEmpty()) {
                    try {
                        ((LifeCycled)initiated.pop()).close();
                    }
                    catch (Exception closeException) {
                        this.logger.error("Failed to close() while shutting down because of .init() having thrown", closeException);
                    }
                }
                throw initException;
            }
        }
    }

    private void runCloseHooks() throws Exception {
        ArrayDeque<LifeCycled> initiated = new ArrayDeque<LifeCycled>();
        for (LifeCycled hook : this.hooks) {
            initiated.addFirst(hook);
        }
        Exception firstFailure = null;
        while (!initiated.isEmpty()) {
            try {
                ((LifeCycled)initiated.pop()).close();
            }
            catch (Exception closeException) {
                if (firstFailure == null) {
                    firstFailure = closeException;
                    continue;
                }
                this.logger.error("A LifeCyclable has thrown already while closing down", closeException);
            }
        }
        if (firstFailure != null) {
            throw firstFailure;
        }
    }

    private void fireTransitionEvent(Status previousStatus, Status newStatus) {
        for (StateChangeListener listener : this.listeners) {
            listener.stateTransition(previousStatus, newStatus);
        }
    }

    final class Transition {
        private final InternalStatus.Transition st;
        private final Thread thread;
        private final String action;

        public Transition(InternalStatus.Transition st, Thread thread, String action) {
            this.st = st;
            this.thread = thread;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            try {
                switch (this.st.to()) {
                    case AVAILABLE: {
                        StatusTransitioner.this.runInitHooks();
                        break;
                    }
                    case UNINITIALIZED: {
                        StatusTransitioner.this.maintenanceLease = null;
                        StatusTransitioner.this.runCloseHooks();
                        break;
                    }
                    case MAINTENANCE: {
                        StatusTransitioner.this.maintenanceLease = this.thread;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Didn't expect that enum value: " + (Object)((Object)this.st.to()));
                    }
                }
                this.st.succeeded();
            }
            catch (Exception e) {
                this.st.failed();
                throw new StateTransitionException(e);
            }
            try {
                StatusTransitioner.this.fireTransitionEvent(this.st.from().toPublicStatus(), this.st.to().toPublicStatus());
            }
            finally {
                StatusTransitioner.this.maintenanceLease = this.thread;
                StatusTransitioner.this.logger.debug("{} successful.", (Object)this.action);
            }
        }

        public StateTransitionException failed(Throwable t) {
            if (this.st.done()) {
                if (t != null) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Throwable cannot be thrown if Transition is done."))).initCause(t));
                }
                return null;
            }
            this.st.failed();
            if (t == null) {
                return null;
            }
            StatusTransitioner.this.logger.error("{} failed.", (Object)this.action);
            if (t instanceof StateTransitionException) {
                return (StateTransitionException)t;
            }
            return new StateTransitionException(t);
        }
    }
}

