/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.imageio.IIOException;

public class PredictorDecompressor {
    private final int predictor;
    private int[] bitsPerSample;
    private int[] sampleFormat;
    private int samplesPerPixel;
    private ByteOrder byteOrder;

    public PredictorDecompressor(int predictor, int[] bitsPerSample, int[] sampleFormat, int samplesPerPixel, ByteOrder byteOrder) {
        this.predictor = predictor;
        this.bitsPerSample = bitsPerSample;
        this.sampleFormat = sampleFormat;
        this.samplesPerPixel = samplesPerPixel;
        this.byteOrder = byteOrder;
    }

    public void decompress(byte[] buf, int bufOffset, int dstOffset, int srcHeight, int srcWidth, int bytesPerRow) throws IIOException {
        block24: {
            block22: {
                block26: {
                    block25: {
                        block23: {
                            if (this.predictor != 2) break block22;
                            if (this.bitsPerSample[0] != 8) break block23;
                            for (int j = 0; j < srcHeight; ++j) {
                                int count = bufOffset + this.samplesPerPixel * (j * srcWidth + 1);
                                for (int i = this.samplesPerPixel; i < srcWidth * this.samplesPerPixel; ++i) {
                                    int n = count;
                                    buf[n] = (byte)(buf[n] + buf[count - this.samplesPerPixel]);
                                    ++count;
                                }
                            }
                            break block24;
                        }
                        if (this.bitsPerSample[0] != 16) break block25;
                        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            for (int j = 0; j < srcHeight; ++j) {
                                int count = dstOffset + this.samplesPerPixel * (j * srcWidth + 1) * 2;
                                for (int i = this.samplesPerPixel; i < srcWidth * this.samplesPerPixel; ++i) {
                                    int curr = buf[count] & 0xFF | buf[count + 1] << 8;
                                    int prev = buf[count - this.samplesPerPixel * 2] & 0xFF | buf[count + 1 - this.samplesPerPixel * 2] << 8;
                                    buf[count] = (byte)(curr += prev);
                                    buf[count + 1] = (byte)(curr >> 8);
                                    count += 2;
                                }
                            }
                        } else {
                            for (int j = 0; j < srcHeight; ++j) {
                                int count = dstOffset + this.samplesPerPixel * (j * srcWidth + 1) * 2;
                                for (int i = this.samplesPerPixel; i < srcWidth * this.samplesPerPixel; ++i) {
                                    int curr = buf[count + 1] & 0xFF | buf[count] << 8;
                                    int prev = buf[count + 1 - this.samplesPerPixel * 2] & 0xFF | buf[count - this.samplesPerPixel * 2] << 8;
                                    buf[count + 1] = (byte)(curr += prev);
                                    buf[count] = (byte)(curr >> 8);
                                    count += 2;
                                }
                            }
                        }
                        break block24;
                    }
                    if (this.bitsPerSample[0] != 32) break block26;
                    if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        for (int j = 0; j < srcHeight; ++j) {
                            int count = dstOffset + this.samplesPerPixel * (j * srcWidth + 1) * 4;
                            int pbase = count - this.samplesPerPixel * 4;
                            int prev = TIFFDecompressor.readIntegerFromBuffer(buf, pbase, pbase + 1, pbase + 2, pbase + 3);
                            for (int i = this.samplesPerPixel; i < srcWidth * this.samplesPerPixel; ++i) {
                                int curr = TIFFDecompressor.readIntegerFromBuffer(buf, count, count + 1, count + 2, count + 3);
                                int sum = curr + prev;
                                buf[count] = (byte)(sum & 0xFF);
                                buf[count + 1] = (byte)(sum >> 8 & 0xFF);
                                buf[count + 2] = (byte)(sum >> 16 & 0xFF);
                                buf[count + 3] = (byte)(sum >> 24 & 0xFF);
                                count += 4;
                                prev = sum;
                            }
                        }
                    } else {
                        for (int j = 0; j < srcHeight; ++j) {
                            int count = dstOffset + this.samplesPerPixel * (j * srcWidth + 1) * 4;
                            int pbase = count - this.samplesPerPixel * 4;
                            int prev = TIFFDecompressor.readIntegerFromBuffer(buf, pbase + 3, pbase + 2, pbase + 1, pbase);
                            for (int i = this.samplesPerPixel; i < srcWidth * this.samplesPerPixel; ++i) {
                                int curr = TIFFDecompressor.readIntegerFromBuffer(buf, count + 3, count + 2, count + 1, count);
                                int sum = curr + prev;
                                buf[count + 3] = (byte)(sum & 0xFF);
                                buf[count + 2] = (byte)(sum >> 8 & 0xFF);
                                buf[count + 1] = (byte)(sum >> 16 & 0xFF);
                                buf[count] = (byte)(sum >> 24 & 0xFF);
                                count += 4;
                                prev = sum;
                            }
                        }
                    }
                    break block24;
                }
                throw new IIOException("Unexpected branch of Horizontal differencing Predictor, bps=" + this.bitsPerSample[0]);
            }
            if (this.predictor != 3) break block24;
            int bytesPerSample = this.bitsPerSample[0] / 8;
            if (bytesPerRow % (bytesPerSample * this.samplesPerPixel) != 0) {
                throw new IIOException("The number of bytes in a row (" + bytesPerRow + ") is not divisibleby the number of bytes per pixel (" + bytesPerSample * this.samplesPerPixel + ")");
            }
            for (int j = 0; j < srcHeight; ++j) {
                int k;
                int i;
                int offset = bufOffset + j * bytesPerRow;
                int count = offset + this.samplesPerPixel;
                for (int i2 = this.samplesPerPixel; i2 < bytesPerRow; ++i2) {
                    int n = count;
                    buf[n] = (byte)(buf[n] + buf[count - this.samplesPerPixel]);
                    ++count;
                }
                byte[] tmp = Arrays.copyOfRange(buf, offset, offset + bytesPerRow);
                int samplesPerRow = srcWidth * this.samplesPerPixel;
                if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                    for (i = 0; i < samplesPerRow; ++i) {
                        for (k = 0; k < bytesPerSample; ++k) {
                            buf[offset + i * bytesPerSample + k] = tmp[k * samplesPerRow + i];
                        }
                    }
                    continue;
                }
                for (i = 0; i < samplesPerRow; ++i) {
                    for (k = 0; k < bytesPerSample; ++k) {
                        buf[offset + i * bytesPerSample + k] = tmp[(bytesPerSample - k - 1) * samplesPerRow + i];
                    }
                }
            }
        }
    }

    public void validate() throws IIOException {
        block6: {
            block5: {
                if (this.predictor != 2) break block5;
                int len = this.bitsPerSample.length;
                int bps = this.bitsPerSample[0];
                if (bps != 8 && bps != 16 && bps != 32) {
                    throw new IIOException(bps + "-bit samples are not supported for Horizontal differencing Predictor");
                }
                for (int i = 0; i < len; ++i) {
                    if (this.bitsPerSample[i] == bps) continue;
                    throw new IIOException("Varying sample width is not supported for Horizontal differencing Predictor (first: " + bps + ", unexpected:" + this.bitsPerSample[i] + ")");
                }
                break block6;
            }
            if (this.predictor != 3) break block6;
            int len = this.bitsPerSample.length;
            int bps = this.bitsPerSample[0];
            if (bps != 16 && bps != 24 && bps != 32 && bps != 64) {
                throw new IIOException(bps + "-bit samples are not supported for Floating point Predictor");
            }
            for (int i = 0; i < len; ++i) {
                if (this.bitsPerSample[i] == bps) continue;
                throw new IIOException("Varying sample width is not supported for Floating point Predictor (first: " + bps + ", unexpected:" + this.bitsPerSample[i] + ")");
            }
            for (int sf : this.sampleFormat) {
                if (sf == 3) continue;
                throw new IIOException("Floating point Predictor not supportedwith " + sf + " data format");
            }
        }
    }
}

