/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.spi.JsonProvider;
import javax.swing.Icon;
import org.geotools.geometry.jts.JTS;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.tests.DuplicateWay;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.gui.DialogPrompter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.ReflectionUtils;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public abstract class GeographicReader
extends AbstractReader {
    protected static CoordinateReferenceSystem wgs84;
    private final GeographicHandler handler;
    private final GeographicHandler[] defaultHandlers;
    protected final Map<LatLon, Node> nodes = new HashMap<LatLon, Node>();
    protected CoordinateReferenceSystem crs;
    protected MathTransform transform;
    private static final Map<String, Integer> esriWkid;

    public GeographicReader(GeographicHandler handler, GeographicHandler[] defaultHandlers) {
        this.handler = handler;
        this.defaultHandlers = defaultHandlers;
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    protected Node getNode(Point p, LatLon key) {
        Node n = this.nodes.get(key);
        if (n == null && this.handler != null && this.handler.checkNodeProximity()) {
            LatLon ll = new LatLon(p.getY(), p.getX());
            for (Node node : this.nodes.values()) {
                if (!node.equalsEpsilon((ILatLon)ll, 1.0E-7)) continue;
                return node;
            }
        }
        return n;
    }

    protected Node createOrGetNode(Point p) throws MismatchedDimensionException, TransformException {
        return this.createOrGetNode(p, null);
    }

    protected Node createOrGetNode(Point p, String ele) throws MismatchedDimensionException, TransformException {
        LatLon key;
        if (!p.isValid()) {
            throw new IllegalArgumentException("Invalid point: " + p);
        }
        Point p2 = (Point)JTS.transform((Geometry)p, (MathTransform)this.transform);
        Node n = this.getNode(p2, key = new LatLon(p2.getY(), p2.getX()));
        if (n == null) {
            n = new Node(key);
            if (ele != null) {
                n.put("ele", ele);
            }
            if (this.handler == null || this.handler.useNodeMap()) {
                this.nodes.put(key, n);
            }
            this.ds.addPrimitive((OsmPrimitive)n);
        } else if (n.getDataSet() == null) {
            this.ds.addPrimitive((OsmPrimitive)n);
        }
        return n;
    }

    protected Node createOrGetEmptyNode(Point p) throws MismatchedDimensionException, TransformException {
        LatLon key;
        Point p2 = (Point)JTS.transform((Geometry)p, (MathTransform)this.transform);
        Node n = this.getNode(p2, key = new LatLon(p2.getY(), p2.getX()));
        if (n != null && n.hasKeys()) {
            n = null;
        }
        if (n == null) {
            n = new Node(key);
            if (this.handler == null || this.handler.useNodeMap()) {
                this.nodes.put(key, n);
            }
            this.ds.addPrimitive((OsmPrimitive)n);
        } else if (n.getDataSet() == null) {
            this.ds.addPrimitive((OsmPrimitive)n);
        }
        return n;
    }

    protected <T extends OsmPrimitive> T addOsmPrimitive(T p) {
        this.ds.addPrimitive(p);
        return p;
    }

    protected final Way createWay() {
        return this.addOsmPrimitive(new Way());
    }

    protected final Way createOrGetWay(LineString ls) {
        Way w = null;
        Way tempWay = new Way();
        if (ls != null) {
            for (int i = 0; i < ls.getNumPoints(); ++i) {
                try {
                    tempWay.addNode(this.createOrGetNode(ls.getPointN(i)));
                    continue;
                }
                catch (IllegalArgumentException | TransformException e) {
                    Logging.error((String)("Exception for " + ls + ": " + e.getClass().getName() + ": " + e.getMessage()));
                }
            }
            if (tempWay.getNodesCount() > 0) {
                SubclassFilteredCollection candidates = Utils.filteredCollection((Collection)tempWay.firstNode().getReferrers(), Way.class);
                candidates.remove(tempWay);
                List tempNodes = DuplicateWay.getOrderedNodes((Way)tempWay);
                for (Way candidate : candidates) {
                    List candNodesA = DuplicateWay.getOrderedNodes((Way)candidate);
                    ArrayList candNodesB = new ArrayList(candNodesA);
                    Collections.reverse(candNodesB);
                    if (!tempNodes.equals(candNodesA) && !tempNodes.equals(candNodesB)) continue;
                    w = candidate;
                    break;
                }
            }
        }
        if (w == null) {
            w = this.createWay();
            w.setNodes(tempWay.getNodes());
        }
        return w;
    }

    protected final Relation createMultipolygon() {
        Relation r = new Relation();
        r.put("type", "multipolygon");
        return this.addOsmPrimitive(r);
    }

    protected final void addWayToMp(Relation r, String role, Way w) {
        r.addMember(new RelationMember(role, (OsmPrimitive)w));
    }

    protected static final boolean warnLenientMethod(final Component parent, final CoordinateReferenceSystem crs) {
        return new DialogPrompter<ExtendedDialog>(){

            @Override
            protected ExtendedDialog buildDialog() {
                ExtendedDialog dlg = new ExtendedDialog(parent, I18n.tr((String)"Cannot transform to WGS84", (Object[])new Object[0]), new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Continue", (Object[])new Object[0])});
                dlg.setContent("<html>" + I18n.tr((String)"JOSM was unable to find a strict mathematical transformation between ''{0}'' and WGS84.<br /><br />Do you want to try a <i>lenient</i> method, which will perform a non-precise transformation (<b>with location errors up to 1 km</b>) ?<br/><br/>If so, <b>do NOT upload</b> such data to OSM !", (Object[])new Object[]{crs.getName()}) + "</html>");
                dlg.setButtonIcons(new Icon[]{new ImageProvider("cancel").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get(), new ImageProvider("ok").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get()});
                dlg.setToolTipTexts(new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Try lenient method", (Object[])new Object[0])});
                dlg.setIcon(2);
                dlg.setCancelButton(new Integer[]{1});
                return dlg;
            }
        }.promptInEdt().getValue() != 2;
    }

    private static void compareDebug(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        Logging.debug((String)("-- COMPARING " + crs1.getName() + " WITH " + crs2.getName() + " --"));
        GeographicReader.compareDebug("class", crs1.getClass(), crs2.getClass());
        CoordinateSystem cs1 = crs1.getCoordinateSystem();
        CoordinateSystem cs2 = crs2.getCoordinateSystem();
        if (!GeographicReader.compareDebug("cs", (IdentifiedObject)cs1, (IdentifiedObject)cs2)) {
            int dim1 = cs1.getDimension();
            int dim2 = cs2.getDimension();
            if (GeographicReader.compareDebug("cs.dim", dim1, dim2)) {
                for (int i = 0; i < dim1; ++i) {
                    GeographicReader.compareDebug("cs.axis" + i, (IdentifiedObject)cs1.getAxis(i), (IdentifiedObject)cs1.getAxis(i));
                }
            }
        }
        if (crs1 instanceof AbstractSingleCRS) {
            Datum datum2;
            Datum datum1 = ((AbstractSingleCRS)crs1).getDatum();
            if (!GeographicReader.compareDebug("datum", (IdentifiedObject)datum1, (IdentifiedObject)(datum2 = ((AbstractSingleCRS)crs2).getDatum())) && datum1 instanceof AbstractIdentifiedObject) {
                AbstractIdentifiedObject adatum1 = (AbstractIdentifiedObject)datum1;
                AbstractIdentifiedObject adatum2 = (AbstractIdentifiedObject)datum2;
                GeographicReader.compareDebug("datum.name1", adatum1.nameMatches(adatum2.getName().getCode()), adatum1.getName(), adatum2.getName());
                GeographicReader.compareDebug("datum.name2", adatum2.nameMatches(adatum1.getName().getCode()), adatum2.getName(), adatum1.getName());
            }
            if (crs1 instanceof AbstractDerivedCRS) {
                AbstractDerivedCRS adcrs1 = (AbstractDerivedCRS)crs1;
                AbstractDerivedCRS adcrs2 = (AbstractDerivedCRS)crs2;
                GeographicReader.compareDebug("baseCRS", (IdentifiedObject)adcrs1.getBaseCRS(), (IdentifiedObject)adcrs2.getBaseCRS());
                GeographicReader.compareDebug("conversionFromBase", (IdentifiedObject)adcrs1.getConversionFromBase(), (IdentifiedObject)adcrs2.getConversionFromBase());
            }
        }
        Logging.debug((String)"-- COMPARING FINISHED --");
    }

    private static boolean compareDebug(String text, Object o1, Object o2) {
        return GeographicReader.compareDebug(text, o1.equals(o2), o1, o2);
    }

    private static boolean compareDebug(String text, IdentifiedObject o1, IdentifiedObject o2) {
        return GeographicReader.compareDebug(text, (AbstractIdentifiedObject)o1, (AbstractIdentifiedObject)o2);
    }

    private static boolean compareDebug(String text, AbstractIdentifiedObject o1, AbstractIdentifiedObject o2) {
        return GeographicReader.compareDebug(text, o1.equals(o2, false), o1, o2);
    }

    private static boolean compareDebug(String text, boolean result, Object o1, Object o2) {
        Logging.debug((String)(text + ": " + result + "(" + o1 + ", " + o2 + ")"));
        return result;
    }

    private static InputStream getEsriWkidStream() {
        InputStream in = GeographicReader.class.getResourceAsStream("/resources/org/openstreetmap/josm/plugins/opendata/core/resources/wkid.json");
        if (in == null) {
            in = GeographicReader.class.getResourceAsStream("/resources/org/openstreetmap/josm/plugins/opendata/core/resources/wkid.json".replaceFirst("/resources", ""));
        }
        return in;
    }

    private static void loadEsriWkid() throws IOException {
        Logging.info((String)"Loading ESRI WKID database...");
        try (InputStream in = GeographicReader.getEsriWkidStream();
             JsonReader json = JsonProvider.provider().createReader(in);){
            JsonObject root = json.readObject();
            JsonArray wkids = root.getJsonArray("wkids");
            JsonArray labels = root.getJsonArray("labels");
            if (wkids.size() != labels.size()) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < wkids.size(); ++i) {
                esriWkid.put(labels.getString(i), wkids.getInt(i));
            }
        }
        Logging.info((String)"ESRI WKID database loaded");
    }

    private static Integer getEpsgCodeFromEsriWkid(String wkid) {
        if (esriWkid.isEmpty()) {
            try {
                GeographicReader.loadEsriWkid();
            }
            catch (IOException e) {
                Logging.error((Throwable)e);
            }
        }
        return esriWkid.get(wkid);
    }

    protected void findMathTransform(Component parent, boolean findSimiliarCrs) throws FactoryException, UserCancelException, GeoMathTransformException {
        block25: {
            try {
                Integer epsgCode;
                String wkid;
                if (this.crs instanceof AbstractIdentifiedObject && this.crs.getIdentifiers().isEmpty() && (wkid = this.crs.getName().getCode()) != null && (epsgCode = GeographicReader.getEpsgCodeFromEsriWkid(wkid)) != null) {
                    try {
                        Field f = AbstractIdentifiedObject.class.getDeclaredField("identifiers");
                        ReflectionUtils.setObjectsAccessible((AccessibleObject[])new AccessibleObject[]{f});
                        f.set(this.crs, Collections.singleton(new NamedIdentifier(Citations.fromName((String)"EPSG"), epsgCode.toString())));
                    }
                    catch (ReflectiveOperationException | SecurityException e) {
                        Logging.error((Throwable)e);
                    }
                }
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)wgs84);
            }
            catch (OperationNotFoundException e) {
                Logging.info((String)(this.crs.getName() + ": " + e.getMessage()));
                if (findSimiliarCrs) {
                    ArrayList<CoordinateReferenceSystem> candidates = new ArrayList<CoordinateReferenceSystem>();
                    for (String code : CRS.getAuthorityFactory((boolean)false).getAuthorityCodes(ProjectedCRS.class)) {
                        try {
                            CoordinateReferenceSystem candidate = CRS.decode((String)code);
                            if (!(candidate instanceof AbstractCRS) || !(this.crs instanceof AbstractIdentifiedObject)) continue;
                            Hints.putSystemDefault((RenderingHints.Key)Hints.COMPARISON_TOLERANCE, (Object)Config.getPref().getDouble("opendata.crs.comparison_tolerance", OdConstants.DEFAULT_CRS_COMPARISON_TOLERANCE.doubleValue()));
                            if (((AbstractCRS)candidate).equals((AbstractIdentifiedObject)this.crs, false)) {
                                Logging.info((String)("Found a potential CRS: " + candidate.getName()));
                                candidates.add(candidate);
                            } else if (Config.getPref().getBoolean("opendata.crs.comparison_debug", false)) {
                                GeographicReader.compareDebug(this.crs, candidate);
                            }
                            Hints.removeSystemDefault((RenderingHints.Key)Hints.COMPARISON_TOLERANCE);
                        }
                        catch (FactoryException ex) {
                            Logging.trace((Throwable)ex);
                        }
                    }
                    if (candidates.size() > 1) {
                        Logging.warn((String)("Found several potential CRS: " + Arrays.toString(candidates.toArray())));
                    }
                    if (!candidates.isEmpty()) {
                        CoordinateReferenceSystem newCRS = (CoordinateReferenceSystem)candidates.get(0);
                        try {
                            this.transform = CRS.findMathTransform((CoordinateReferenceSystem)newCRS, (CoordinateReferenceSystem)wgs84, (boolean)false);
                        }
                        catch (OperationNotFoundException ex) {
                            Logging.warn((String)(newCRS.getName() + ": " + e.getMessage()));
                        }
                    }
                }
                if (this.transform != null) break block25;
                if (this.handler != null) {
                    try {
                        this.transform = this.handler.findMathTransform(this.crs, wgs84, false);
                    }
                    catch (OperationNotFoundException ex) {
                        Logging.warn((String)(this.crs.getName() + ": " + ex.getMessage()));
                    }
                } else {
                    for (GeographicHandler geoHandler : this.defaultHandlers) {
                        try {
                            this.transform = geoHandler.findMathTransform(this.crs, wgs84, false);
                            if (this.transform == null) continue;
                            break;
                        }
                        catch (OperationNotFoundException ex) {
                            Logging.warn((String)(this.crs.getName() + ": " + ex.getMessage()));
                        }
                    }
                }
                if (this.transform != null) break block25;
                if (!GraphicsEnvironment.isHeadless() && GeographicReader.warnLenientMethod(parent, this.crs)) {
                    throw new UserCancelException();
                }
                Logging.info((String)"Searching for a lenient math transform.");
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)wgs84, (boolean)true);
            }
        }
        if (this.transform == null) {
            throw new GeoMathTransformException("Unable to find math transform !");
        }
    }

    static {
        try {
            wgs84 = CRS.decode((String)"EPSG:4326");
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        esriWkid = new TreeMap<String, Integer>();
    }
}

