/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceProvider;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.tools.Logging;

public abstract class AbstractModule
implements Module {
    protected final List<Class<? extends AbstractDataSetHandler>> handlers = new ArrayList<Class<? extends AbstractDataSetHandler>>();
    private final List<AbstractDataSetHandler> instanciatedHandlers = new ArrayList<AbstractDataSetHandler>();
    protected final ModuleInformation info;

    public AbstractModule(ModuleInformation info) {
        this.info = info;
    }

    @Override
    public ModuleInformation getModuleInformation() {
        return this.info;
    }

    @Override
    public List<Class<? extends AbstractDataSetHandler>> getHandlers() {
        return this.handlers;
    }

    @Override
    public String getDisplayedName() {
        return this.info.name;
    }

    @Override
    public SourceProvider getMapPaintStyleSourceProvider() {
        final ArrayList<ExtendedSourceEntry> sources = new ArrayList<ExtendedSourceEntry>();
        for (AbstractDataSetHandler handler : this.getInstanciatedHandlers()) {
            ExtendedSourceEntry src;
            if (handler == null || (src = handler.getMapPaintStyle()) == null) continue;
            String path = OdPlugin.getInstance().getResourcesDirectory() + File.separator + src.url.replace("resource://", "").replace('/', File.separatorChar);
            int n = 0;
            byte[] buffer = new byte[4096];
            try {
                InputStream in = this.getClass().getResourceAsStream(src.url.substring("resource://".length() - 1));
                try (FileOutputStream out = new FileOutputStream(path);){
                    String dir = path.substring(0, path.lastIndexOf(File.separatorChar));
                    if (new File(dir).mkdirs() && Logging.isDebugEnabled()) {
                        Logging.debug((String)("Created directory: " + dir));
                    }
                    while ((n = in.read(buffer)) > 0) {
                        out.write(buffer, 0, n);
                    }
                    src.url = "file://" + path;
                    sources.add(src);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                Logging.error((String)e.getMessage());
            }
        }
        return sources.isEmpty() ? null : new SourceProvider(){

            public Collection<SourceEntry> getSources() {
                return sources;
            }
        };
    }

    @Override
    public SourceProvider getPresetSourceProvider() {
        final ArrayList<ExtendedSourceEntry> sources = new ArrayList<ExtendedSourceEntry>();
        for (AbstractDataSetHandler handler : this.getInstanciatedHandlers()) {
            if (handler == null || handler.getTaggingPreset() == null) continue;
            sources.add(handler.getTaggingPreset());
        }
        return sources.isEmpty() ? null : new SourceProvider(){

            public Collection<SourceEntry> getSources() {
                return sources;
            }
        };
    }

    @Override
    public final List<AbstractDataSetHandler> getNewlyInstanciatedHandlers() {
        ArrayList<AbstractDataSetHandler> result = new ArrayList<AbstractDataSetHandler>();
        for (Class<? extends AbstractDataSetHandler> handlerClass : this.handlers) {
            if (handlerClass == null) continue;
            try {
                result.add(handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException t) {
                Logging.log((Level)Logging.LEVEL_ERROR, (String)("Cannot instantiate " + handlerClass + " because of " + t.getClass().getName()), (Throwable)t);
            }
        }
        return result;
    }

    private List<AbstractDataSetHandler> getInstanciatedHandlers() {
        if (this.instanciatedHandlers.isEmpty()) {
            this.instanciatedHandlers.addAll(this.getNewlyInstanciatedHandlers());
        }
        return this.instanciatedHandlers;
    }
}

