/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CollectionMap;

public abstract class StyleDesc<S extends StyleStyle> {
    private final Class<S> clazz;
    private final XMLVersion version;
    private final String family;
    private final String baseName;
    private final CollectionMap<String, String> refElements;
    private final CollectionMap<String, String> multiRefElements;

    public static <C extends StyleStyle> StyleDesc<C> copy(final StyleDesc<C> styleDesc, XMLVersion xMLVersion) {
        StyleDesc styleDesc2 = new StyleDesc<C>(styleDesc.getStyleClass(), xMLVersion, styleDesc.getFamily(), styleDesc.getBaseName()){

            @Override
            public C create(ODPackage oDPackage, Element element) {
                return styleDesc.create(oDPackage, element);
            }
        };
        styleDesc2.getRefElementsMap().putAll((MultiValuedMap)styleDesc.getRefElementsMap());
        styleDesc2.getMultiRefElementsMap().putAll((MultiValuedMap)styleDesc.getMultiRefElementsMap());
        return styleDesc2;
    }

    protected StyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2, String string3) {
        this(clazz, xMLVersion, string, string2, string3, Collections.singletonList(string3 + ":" + string));
    }

    protected StyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2, String string3, List<String> list) {
        this(clazz, xMLVersion, string, string2);
        this.getRefElementsMap().putAll(string3 + ":style-name", list);
    }

    protected StyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2) {
        this.clazz = clazz;
        this.version = xMLVersion;
        this.family = string;
        this.baseName = string2;
        this.refElements = new CollectionMap();
        this.multiRefElements = new CollectionMap(4);
    }

    public abstract S create(ODPackage var1, Element var2);

    final Class<S> getStyleClass() {
        return this.clazz;
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    public final String getFamily() {
        return this.family;
    }

    public final String getBaseName() {
        return this.baseName;
    }

    protected final Collection<String> getRefElements() {
        return this.getRefElementsMap().values();
    }

    protected final CollectionMap<String, String> getRefElementsMap() {
        return this.refElements;
    }

    protected final CollectionMap<String, String> getMultiRefElementsMap() {
        return this.multiRefElements;
    }
}

