/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.indriya.AbstractUnit;
import tec.units.indriya.unit.BaseUnit;
import tec.units.indriya.unit.Units;

public final class QuantityDimension
implements Dimension,
Serializable {
    private static final Logger logger = Logger.getLogger(QuantityDimension.class.getName());
    private static final long serialVersionUID = 123289037718650030L;
    public static final Dimension NONE = new QuantityDimension(AbstractUnit.ONE);
    public static final Dimension LENGTH = new QuantityDimension('L');
    public static final Dimension MASS = new QuantityDimension('M');
    public static final Dimension TIME = new QuantityDimension('T');
    public static final Dimension ELECTRIC_CURRENT = new QuantityDimension('I');
    public static final Dimension TEMPERATURE = new QuantityDimension('\u0398');
    public static final Dimension AMOUNT_OF_SUBSTANCE = new QuantityDimension('N');
    public static final Dimension LUMINOUS_INTENSITY = new QuantityDimension('J');
    private final Unit<?> pseudoUnit;

    public static <Q extends Quantity<Q>> Dimension getInstance(Class<Q> quantityType) {
        return QuantityDimension.of(quantityType);
    }

    public static <Q extends Quantity<Q>> Dimension of(Class<Q> quantityType) {
        Unit<Q> siUnit = Units.getInstance().getUnit(quantityType);
        if (siUnit == null) {
            logger.log(Level.FINER, "Quantity type: " + quantityType + " unknown");
        }
        return siUnit != null ? siUnit.getDimension() : null;
    }

    public static Dimension parse(char symbol) {
        return new QuantityDimension(symbol);
    }

    QuantityDimension(char symbol) {
        this.pseudoUnit = new BaseUnit("[" + symbol + ']', NONE);
    }

    private QuantityDimension(Unit<?> pseudoUnit) {
        this.pseudoUnit = pseudoUnit;
    }

    @Override
    public Dimension multiply(Dimension that) {
        return that instanceof QuantityDimension ? this.multiply((QuantityDimension)that) : this.multiply(that);
    }

    public QuantityDimension multiply(QuantityDimension that) {
        return new QuantityDimension(this.pseudoUnit.multiply(that.pseudoUnit));
    }

    @Override
    public Dimension divide(Dimension that) {
        return this.multiply(that.pow(-1));
    }

    public QuantityDimension divide(QuantityDimension that) {
        return this.multiply(that.pow(-1));
    }

    @Override
    public final QuantityDimension pow(int n) {
        return new QuantityDimension(this.pseudoUnit.pow(n));
    }

    @Override
    public final QuantityDimension root(int n) {
        return new QuantityDimension(this.pseudoUnit.root(n));
    }

    @Override
    public Map<? extends Dimension, Integer> getBaseDimensions() {
        Map<Unit<?>, Integer> pseudoUnits = this.pseudoUnit.getBaseUnits();
        if (pseudoUnits == null) {
            return null;
        }
        HashMap<QuantityDimension, Integer> baseDimensions = new HashMap<QuantityDimension, Integer>();
        for (Map.Entry<Unit<?>, Integer> entry : pseudoUnits.entrySet()) {
            baseDimensions.put(new QuantityDimension(entry.getKey()), entry.getValue());
        }
        return baseDimensions;
    }

    public String toString() {
        return this.pseudoUnit.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuantityDimension) {
            QuantityDimension other = (QuantityDimension)obj;
            return Objects.equals(this.pseudoUnit, other.pseudoUnit);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.pseudoUnit);
    }
}

