/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.fid;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.data.shapefile.fid.IndexedFidWriter;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.files.StorageFile;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.util.logging.Logging;

public class FidIndexer {
    static Logger LOGGER = Logging.getLogger(FidIndexer.class);

    public static synchronized void generate(URL shpURL) throws IOException {
        FidIndexer.generate(new ShpFiles(shpURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(ShpFiles shpFiles) throws IOException {
        LOGGER.fine("Generating fids for " + shpFiles.get(ShpFileType.SHP));
        IndexFile indexFile = null;
        StorageFile file = shpFiles.getStorageFile(ShpFileType.FIX);
        IndexedFidWriter writer = null;
        try {
            indexFile = new IndexFile(shpFiles, false);
            writer = new IndexedFidWriter(shpFiles, file);
            int j = indexFile.getRecordCount();
            for (int i = 0; i < j; ++i) {
                writer.next();
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                file.replaceOriginal();
            }
            finally {
                if (indexFile != null) {
                    indexFile.close();
                }
            }
        }
    }
}

